% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gosling.R
\name{gosling_plot}
\alias{gosling_plot}
\title{Plot a GPos or GRanges Object Using Shiny and Gosling}
\usage{
gosling_plot(
  granges,
  title = "GRanges Plot",
  subtitle = "Stacked nucleotide example",
  plot_type = c("bar", "lollipop"),
  create_app = interactive()
)
}
\arguments{
\item{granges}{A \code{\link[GenomicRanges:GRanges-class]{GenomicRanges::GRanges}} (e.g.,
\code{\link[GenomicRanges:GPos-class]{GenomicRanges::GPos}}) object containing the genomic ranges
to be plotted.}

\item{title}{character(1) Title of the plot. Default is
"GRanges Plot".}

\item{subtitle}{character(1) The subtitle of the plot. Default is
"Stacked nucleotide example".}

\item{plot_type}{character(1) Select the type of gosling plot.
Default is "bar"; available types are described in Details.}

\item{create_app}{logical(1) Produce a Shiny app for Gosling
visualization. Default \code{TRUE} when used interactively.}
}
\value{
\code{gosling_plot()} with \code{create_app = TRUE} returns a
\code{shinyApp} object that, when run, displays the Gosling
plot. When \code{create_app = FALSE}, the (invisible) return value
represents the gosling object to be used in Shiny apps.
}
\description{
\code{plot_granges()} creates a Shiny app that displays a
Gosling plot of a given GRanges object.  It visualizes genomic
ranges with both rectangle and point representations, and
allows for customization of the plot title and subtitle.
}
\details{
The function supports 2 types of plots as selected through the
\code{plot_type} argument: (1) \code{"bar"}: a barplot-like view of the
pathogenicity score at each position, similar to a sequencing
coverage plot, and (2) \code{"lollipop"}: a lollipop plot focusing on
the pathogenicity classification (ambiguous, benign, pathogenic) at
each position. It requires that the \code{\link[GenomicRanges:GRanges-class]{GenomicRanges::GRanges}}
object has the following metadata columns: 'am_class' (effect
classification),'am_pathogenicity' (pathogenicity score), 'ALT'
(alternative allele) and 'REF' (reference allele).
}
\note{
This function requires the \code{shiny}, \code{shiny.gosling}, and
\code{GenomicRanges} packages to be installed.
}
\examples{
## Create a sample GRanges object from AlphamissenseR
gpos <-
    am_data("hg38") |>
    filter(uniprot_id == "Q1W6H9") |>
    to_GPos()

## Plot `gpos` using shiny.gosling
if (requireNamespace("shiny.gosling", quietly = TRUE)) {
   gosling_plot(
       gpos, title = "Q1W6H_track", subtitle = "bar plot example",
       plot_type = "bar", create_app = FALSE
   )
}

}
