context("readSpe2Peps")

test_that("readSpe2Peps works", {
  target_file <- system.file("extdata", "demo_target.Spe2Pep.txt", package = "Aerith")
  psm <- readSpe2Pep(target_file)
  psm <- psm$PSM
  expect_true(nrow(psm) > 10)

  tmp <- tempdir()
  sip_dir <- file.path(tmp, "sip")
  dir.create(sip_dir)
  demo_file <- system.file("extdata", "demo_target.Spe2Pep.txt", package = "Aerith")
  file.copy(demo_file, file.path(sip_dir, "Pan_052322_X13.SIP_C13_050_000target.Spe2Pep.txt"))
  demo_file <- system.file("extdata", "demo_decoy.Spe2Pep.txt", package = "Aerith")
  file.copy(demo_file, file.path(sip_dir, "Pan_052322_X13.SIP_C13_050_000decoy.Spe2Pep.txt"))
  list.files(sip_dir, full.names = TRUE)
  psm <- readSpe2Peps(sip_dir)
  expect_true(nrow(psm[[1]]$PSM) > 10)

  tmp <- tempdir()
  sip_dir <- file.path(tmp, "sip")
  dir.create(sip_dir)
  demo_file <- system.file("extdata", "demo_target.Spe2Pep.txt", package = "Aerith")
  file.copy(demo_file, file.path(sip_dir, "Pan_052322_X13.SIP_C13_050_000target.Spe2Pep.txt"))
  demo_file <- system.file("extdata", "demo_decoy.Spe2Pep.txt", package = "Aerith")
  file.copy(demo_file, file.path(sip_dir, "Pan_052322_X13.SIP_C13_050_000decoy.Spe2Pep.txt"))
  list.files(sip_dir, full.names = TRUE)
  psm <- readSpe2PepFilesScansTopPSMs(sip_dir, 3)
  expect_true(nrow(psm) > 10)

  tmp <- tempdir()
  sip_dir <- file.path(tmp, "sip")
  dir.create(sip_dir)
  demo_file <- system.file("extdata", "demo_target.Spe2Pep.txt", package = "Aerith")
  file.copy(demo_file, file.path(sip_dir, "Pan_052322_X13.SIP_C13_050_000target.Spe2Pep.txt"))
  demo_file <- system.file("extdata", "demo_decoy.Spe2Pep.txt", package = "Aerith")
  file.copy(demo_file, file.path(sip_dir, "Pan_052322_X13.SIP_C13_050_000decoy.Spe2Pep.txt"))
  list.files(sip_dir, full.names = TRUE)
  top3 <-  readSpe2PepFilesScansTopPSMsFromEachFT2Parallel(sip_dir, 3)
  expect_true(nrow(top3[[1]]) > 10)

  tmp <- tempdir()
  target_dir <- file.path(tmp, "target")
  dir.create(target_dir, showWarnings = FALSE)
  target_file <- system.file("extdata", "demo_target.Spe2Pep.txt", package = "Aerith")
  file.copy(target_file, file.path(target_dir, "Pan_052322_X13.SIP_C13_050_000Pct.Spe2Pep.txt"))
  decoy_dir <- file.path(tmp, "decoy")
  dir.create(decoy_dir, showWarnings = FALSE)
  decoy_file <- system.file("extdata", "demo_decoy.Spe2Pep.txt", package = "Aerith")
  file.copy(decoy_file, file.path(decoy_dir, "Pan_052322_X13.SIP_C13_050_000Pct.Spe2Pep.txt"))
  list.files(target_dir, full.names = TRUE)
  list.files(decoy_dir, full.names = TRUE)
  top3 <- readSpe2PepFilesScansTopPSMsFromEachFT2TargetAndDecoyParallel(target_dir, decoy_dir, 3)
  expect_true(nrow(top3[[1]]) > 10)

  tmp <- tempdir()
  sip_dir <- file.path(tmp, "sip")
  dir.create(sip_dir)
  demo_file <- system.file("extdata", "demo_target.Spe2Pep.txt", package = "Aerith")
  file.copy(demo_file, file.path(sip_dir, "Pan_052322_X13.SIP_C13_050_000target.Spe2Pep.txt"))
  demo_file <- system.file("extdata", "demo_decoy.Spe2Pep.txt", package = "Aerith")
  file.copy(demo_file, file.path(sip_dir, "Pan_052322_X13.SIP_C13_050_000decoy.Spe2Pep.txt"))
  writeSpe2PepFilesScansTopPSMsFromEachFT2Parallel(sip_dir, 3, file.path(sip_dir, "top3.tsv"))
  list.files(sip_dir, full.names = TRUE)
  print(file.info(file.path(sip_dir, "top3.tsv")))
  expect_true(file.exists(file.path(sip_dir, "top3.tsv")))
})

# test_file("tests/testthat/test-readSpe2Peps.R")