% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotProteinSipPct.R
\name{summaryPSMsipPCT}
\alias{summaryPSMsipPCT}
\title{Summarize SIP percent for PSMs}
\usage{
summaryPSMsipPCT(psmPath, SIPthreshold = 5, chargeThreshold = 3)
}
\arguments{
\item{psmPath}{A character string specifying the path to the PSM file.}

\item{SIPthreshold}{Numeric value representing the SIP threshold (default is 5).}

\item{chargeThreshold}{Numeric value representing the parent charge threshold (default is 3).}
}
\value{
A data frame containing summary statistics of the SIP percent values.
}
\description{
This function reads a PSM file and computes summary statistics for the SIP percent values,
including the total count, average, median, Median Absolute Deviation (MAD), standard deviation,
estimated FDR, the number of labeled PSMs, and the median SIP percent for the labeled PSMs.
}
\examples{
demo_file <- system.file("extdata", "demo.psm.txt", package = "Aerith")
summaryStats <- summaryPSMsipPCT(demo_file)
print(summaryStats)

}
