% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{scorePSM}
\alias{scorePSM}
\title{scorePSM}
\usage{
scorePSM(realMZ, realIntensity, realCharge, parentCharge, pepSeq, Atom, Prob)
}
\arguments{
\item{realMZ}{mz vector in MS2 scan}

\item{realIntensity}{intensity vector in MS2 scan}

\item{realCharge}{charge vector in MS2 scan}

\item{parentCharge}{int parent charge of MS2 scan}

\item{pepSeq}{a string of peptide}

\item{Atom}{"C13" or "N15"}

\item{Prob}{its SIP abundance (0.0~1.0)}
}
\value{
a score of this PSM
}
\description{
scorePSM
}
\examples{
demo_file <- system.file("extdata", "107728.FT2", package = "Aerith")
scan1 <- readOneScanMS2(ftFile = demo_file, 107728)
score <- scorePSM(scan1$peaks$mz,
        scan1$peaks$intensity, scan1$peaks$charge, 2,
        "[HSQVFSTAEDNQSAVTIHVLQGER]", "C13", 0.0107)
}
