% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{readFilesScansTopPSMsFromOneFT2}
\alias{readFilesScansTopPSMsFromOneFT2}
\title{readFilesScansTopPSMsFromOneFT2 read each scan's top PSMs from multiple .sip files of one .FT2 file}
\usage{
readFilesScansTopPSMsFromOneFT2(workingPath, pattern, topN)
}
\arguments{
\item{workingPath}{a full path with .sip files in it}

\item{pattern}{a regex pattern of the .FT2 file}

\item{topN}{store top N PSMs of each scan of one .FT2 file}
}
\value{
a dataframe of top N PSMs
}
\description{
readFilesScansTopPSMsFromOneFT2 read each scan's top PSMs from multiple .sip files of one .FT2 file
}
\examples{
demo_dir <- system.file("extdata", package = "Aerith")
re <- readFilesScansTopPSMsFromOneFT2(demo_dir, ".*demo.*", 3)
head(re)
}
