% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAAspectra.R
\name{getRealScanWithCharge}
\alias{getRealScanWithCharge}
\title{Convert one scan in scans with real charges and raw intensities from list of scans of ft file to AAspectra class}
\usage{
getRealScanWithCharge(scanNumber, ft)
}
\arguments{
\item{scanNumber}{Integer. The scan number of one scan.}

\item{ft}{List. The list of scans from an ft file.}
}
\value{
AAspectra object containing the scan data.
}
\description{
Convert one scan in scans with real charges and raw intensities from list of scans of ft file to AAspectra class
}
\examples{
demo_file <- system.file("extdata", "demo.FT2", package = "Aerith")
a <- readAllScanMS2(demo_file)
b <- getRealScanWithCharge(1388, a)
head(slot(b, "spectra"))
}
