% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SIPfft.R
\name{cal_isotope_peaks_fft}
\alias{cal_isotope_peaks_fft}
\title{Calculate Isotope Peaks using FFT}
\usage{
cal_isotope_peaks_fft(formula, N_width = 100, min_abundance = 1e-04, ...)
}
\arguments{
\item{formula}{A character string representing the chemical formula.}

\item{N_width}{An integer specifying the width of the isotope envelope in FFT. Default is 100.
Wider isotopic envolope will require larger N_width.}

\item{min_abundance}{A numeric value specifying the minimum abundance threshold
for the peaks. Default is 0.0001.}

\item{...}{Additional arguments passed to the function. For example C13=0.5 will change
the abundance of C13 to 0.5 and adjust the abundance of C12 accordingly.}
}
\value{
data.frame A data frame containing the calculated isotope peaks mass and their abundances.
}
\description{
This function calculates the isotope peaks for a given chemical formula using
Fast Fourier Transform (FFT).  It approximates the delta mass of isotopes is one neutron mass
and ignore the fine structure of isotopes.
}
\examples{
# Example usage:
cal_isotope_peaks_fft("C6H12O6")
cal_isotope_peaks_fft("C6H12O6", N_width = 200, min_abundance = 0.001, C13 = 0.5)

}
