% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SIPmontecarlo.R
\name{cal_isotope_numbers_SIP}
\alias{cal_isotope_numbers_SIP}
\title{Calculate Isotope Numbers for SIP}
\usage{
cal_isotope_numbers_SIP(formula, num_simulations = 10000, ...)
}
\arguments{
\item{formula}{A character string representing the chemical formula, "C6H12O6" for example.}

\item{num_simulations}{An integer specifying the number of simulations to run. Default is 10,000.}

\item{...}{Additional arguments passed to the function, C13=0.5 for example to set the abundance of C13 to 0.5.}
}
\value{
A dataframe containing the results of the isotope number and mass calculations.
}
\description{
This function calculates the isotope numbers for Stable Isotope Probing (SIP) based on a given chemical formula
using a Monte Carlo simulation approach.
}
\examples{
cal_isotope_numbers_SIP("C6H12O6")
cal_isotope_numbers_SIP("C6H12O6", num_simulations = 10000, C13 = 0.5)
}
