## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>",
    fig.width = 10
)

## ----include = FALSE, eval=FALSE----------------------------------------------
# rmarkdown::render("Theoretic-spectra-generation-of-SIP-labeled-peptide.Rmd", output_dir = "../doc/")

## ----setup--------------------------------------------------------------------
library(Aerith)
library(ggplot2)

## -----------------------------------------------------------------------------
a <- precursor_peak_calculator("PEPTIDECCCC")
head(a, 5)
calPepAtomCount("PEPTIDECCCC")
calPepPrecursorMass("PEPTIDECCCC", "C13", 0.0107)

## -----------------------------------------------------------------------------
a <- getPrecursorSpectra("PEPTIDE", 2)
plot(a) + scale_x_continuous(breaks = seq(400, 405, by = 1)) + geom_linerange(linewidth = 0.2)
a <- getPrecursorSpectra("PEPTIDE", 1:2)
plot(a)

## -----------------------------------------------------------------------------
df <- BYion_peak_calculator_DIY("PEPTIDE", "C13", 0.0107)
head(df, 5)

## -----------------------------------------------------------------------------
a <- getSipBYionSpectra("KHRIPCDRK", "C13", 0.0107, 1:2, 2)
plot(a) + plotSipBYionLabel(a)

## -----------------------------------------------------------------------------
a <- getSipBYionSpectra("KHRIPCDRK", "C13", 0.0107, 1:2, 0)
plot(a) + plotSipBYionLabel(a)
a <- getSipBYionSpectra("KHRIPCDRK", "C13", 0.0107, 1:2, 2:3)
plot(a) + plotSipBYionLabel(a)

## -----------------------------------------------------------------------------
a <- precursor_peak_calculator_DIY("PEPTIDECCCC", "N15", 0.55)
head(a, 5)
calPepPrecursorMass("PEPTIDECCCC", "C13", 0.55)

## -----------------------------------------------------------------------------
calPepAtomCount("PEPTIDECCCC")
calPepPrecursorMass("PEPTIDECCCC", "C13", 0.0107)
calPepPrecursorMass("PEPTIDECCCC", "C13", 0.5)
calPepPrecursorMass("PEPTIDECCCC", "H2", 0.000115)
calPepPrecursorMass("PEPTIDECCCC", "H2", 0.5)
calPepPrecursorMass("PEPTIDECCCC", "N15", 0.00368)
calPepPrecursorMass("PEPTIDECCCC", "N15", 0.5)
calPepPrecursorMass("PEPTIDECCCC", "O18", 0.00205)
calPepPrecursorMass("PEPTIDECCCC", "O18", 0.5)
calPepPrecursorMass("PEPTIDECCCC", "S34", 0.0429)
calPepPrecursorMass("PEPTIDECCCC", "S34", 0.5)

## -----------------------------------------------------------------------------
calPepAtomCount("PEPTIDECCCC")
df <- precursor_peak_calculator_DIY("PEPTIDECCCC", "C13", 0.0107)
df$Mass[which.max(df$Prob)]
df <- precursor_peak_calculator_DIY("PEPTIDECCCC", "C13", 0.5)
df$Mass[which.max(df$Prob)]
df <- precursor_peak_calculator_DIY("PEPTIDECCCC", "O18", 0.00205)
df$Mass[which.max(df$Prob)]
df <- precursor_peak_calculator_DIY("PEPTIDECCCC", "O18", 0.5)
df$Mass[which.max(df$Prob)]
df <- precursor_peak_calculator_DIY("PEPTIDECCCC", "S34", 0.0429)
df$Mass[which.max(df$Prob)]
df <- precursor_peak_calculator_DIY("PEPTIDECCCC", "S34", 0.5)
df$Mass[which.max(df$Prob)]

## -----------------------------------------------------------------------------
a <- getSipPrecursorSpectra("PEPTIDE", "C13", 0.55, 2)
plot(a) + scale_x_continuous(breaks = seq(400, 420, by = 1)) + geom_linerange(linewidth = 0.2)
a <- getSipPrecursorSpectra("PEPTIDE", "C13", 0.55, 1:2)
plot(a)

## -----------------------------------------------------------------------------
df <- BYion_peak_calculator_DIY("PEPTIDE", "C13", 0.55)
head(df, 5)

## -----------------------------------------------------------------------------
df <- BYion_peak_calculator_DIY("PEPTIDECCCC", "C13", 0.0107)
df <- df[which(df$Kind == "Y6"), ]
df$Mass[which.max(df$Prob)]
df <- BYion_peak_calculator_DIY("PEPTIDECCCC", "C13", 0.5)
df <- df[which(df$Kind == "Y6"), ]
df$Mass[which.max(df$Prob)]
df <- BYion_peak_calculator_DIY("PEPTIDECCCC", "H2", 0.000115)
df <- df[which(df$Kind == "Y6"), ]
df$Mass[which.max(df$Prob)]
df <- BYion_peak_calculator_DIY("PEPTIDECCCC", "H2", 0.5)
df <- df[which(df$Kind == "Y6"), ]
df$Mass[which.max(df$Prob)]
df <- BYion_peak_calculator_DIY("PEPTIDECCCC", "N15", 0.00368)
df <- df[which(df$Kind == "Y6"), ]
df$Mass[which.max(df$Prob)]
df <- BYion_peak_calculator_DIY("PEPTIDECCCC", "N15", 0.5)
df <- df[which(df$Kind == "Y6"), ]
df$Mass[which.max(df$Prob)]

## -----------------------------------------------------------------------------
a <- getSipBYionSpectra("KHRIPCDRK", "C13", 0.55, 1:2, 2)
plot(a) + plotSipBYionLabel(a)

## -----------------------------------------------------------------------------
a <- getSipBYionSpectra("KHRIPCDRK", "C13", 0.55, 1:2, 0)
plot(a) + plotSipBYionLabel(a)
a <- getSipBYionSpectra("KHRIPCDRK", "C13", 0.55, 1:2, 2:3)
plot(a) + plotSipBYionLabel(a)

## ----session-info-------------------------------------------------------------
sessionInfo()

