## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>",
    fig.width = 10
)

## ----include = FALSE, eval=FALSE----------------------------------------------
# rmarkdown::render("Theoretic-spectra-generation-of-SIP-labeled-compound.Rmd", output_dir = "../doc/")

## ----setup--------------------------------------------------------------------
library(Aerith)
library(ggplot2)

## -----------------------------------------------------------------------------
iso1 <- cal_isotope_numbers_SIP("C6H11O6")
plotMolecularIsotopes(iso1) +
    ggtitle(expression(C[6] * H[11] * O[6]^"-" ~ 1.07 * "% " *
        {}^{
            13
        } * C))

## -----------------------------------------------------------------------------
iso2 <- cal_isotope_numbers_SIP("C6H11O6", num_simulations = 50000, C13 = 0.5)
plotMolecularIsotopes(iso2) +
    ggtitle(expression(C[6] * H[11] * O[6]^"-" ~ 50 * "% " *
        {}^{
            13
        } * C))

## -----------------------------------------------------------------------------
iso1 <- cal_isotope_peaks_fft("C6H12O6Na")
plotMolecularFFTisotopes(iso1) +
    ggtitle(expression(C[6] * H[12] * O[6] * Na^"+" ~ 1.07 * "% " *
        {}^{
            13
        } * C))

## -----------------------------------------------------------------------------
iso2 <- cal_isotope_peaks_fft("C6H12O6Na", N_width = 200, min_abundance = 0.001, C13 = 0.5)
plotMolecularFFTisotopes(iso2) +
    ggtitle(expression(C[6] * H[12] * O[6] * Na^"+" ~ 50 * "% " *
        {}^{
            13
        } * C))

## -----------------------------------------------------------------------------
iso1 <- cal_isotope_peaks_fft("C6H11O6")
plotMolecularFFTisotopes(iso1) +
    ggtitle(expression(C[6] * H[11] * O[6]^"-" ~ 1.07 * "% " *
        {}^{
            13
        } * C))

## -----------------------------------------------------------------------------
iso2 <- cal_isotope_peaks_fft("C6H11O6", N_width = 200, min_abundance = 0.001, C13 = 0.5)
plotMolecularFFTisotopes(iso2) +
    ggtitle(expression(C[6] * H[11] * O[6]^"-" ~ 50 * "% " *
        {}^{
            13
        } * C))

## ----session-info-------------------------------------------------------------
sessionInfo()

