% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFootprints.R
\name{plotFootprints}
\alias{plotFootprints}
\title{Plots a footprint estimated by Centipede}
\usage{
plotFootprints(
  Profile,
  Mlen = 0,
  xlab = "Dist. to motif (bp)",
  ylab = "Cut-site probability",
  legLabels = c("For. strand", "Rev. strand"),
  legTitle,
  xlim,
  ylim,
  newpage = TRUE,
  motif,
  segmentation,
  reNormalizeByDistalSig = FALSE,
  ...
)
}
\arguments{
\item{Profile}{A vector with the profile estimated by CENTIPEDE}

\item{Mlen}{Length of the motif for drawing vertical lines delimiting it}

\item{xlab}{Label of the x axis}

\item{ylab}{Label for the y axis}

\item{legLabels}{Labels for legend.}

\item{legTitle}{Title for one of the plot corners}

\item{xlim}{xlim}

\item{ylim}{ylim}

\item{newpage}{Plot the figure in a new page?}

\item{motif}{a pfm object.}

\item{segmentation}{the segmentation position and abundance}

\item{reNormalizeByDistalSig}{Re-normalized the curver by distal signals.}

\item{...}{Not used.}
}
\value{
Null.
}
\description{
Visualizing the footprint profile
}
\examples{
library(MotifDb)
CTCF <- query(MotifDb, c("CTCF"))
CTCF <- as.list(CTCF)
motif <- new("pfm", mat=CTCF[[1]], name="CTCF")
ATACseqQC:::plotFootprints(Profile=sample.int(500), 
                        Mlen=ncol(CTCF[[1]]), motif=motif)
}
\author{
Jianhong Ou
}
