% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aldex-scaleSim.R
\name{aldex.senAnalysis}
\alias{aldex.senAnalysis}
\title{Sensitivity analysis using scale simulation}
\usage{
aldex.senAnalysis(
  aldex_clr,
  gamma,
  test = "t",
  effect = TRUE,
  include.sample.summary = FALSE,
  verbose = FALSE,
  iterate = FALSE,
  ...
)
}
\arguments{
\item{aldex_clr}{An `aldex.clr` object}

\item{gamma}{A vector of positive numeric components. Used as the standard deviation of the scale simulation model.}

\item{test}{A character string. Indicates which tests to perform. "t" runs
Welch's t and Wilcoxon tests. "kw" runs Kruskal-Wallace and glm tests.
"glm" runs a generalized linear model using a \code{model.matrix}.
"corr" runs a correlation test using \code{cor.test}.}

\item{effect}{A boolean. Toggles whether to calculate abundances and effect sizes.}

\item{include.sample.summary}{A boolean. Toggles whether to include median clr
values for each sample. Applies to \code{effect = TRUE}.}

\item{verbose}{A boolean. Toggles whether to print diagnostic information while
running. Useful for debugging errors on large datasets. Applies to
\code{effect = TRUE}.}

\item{iterate}{A boolean. Toggles whether to iteratively perform a test. For example,
this will use the results from an initial "t" routine to seed the reference
(i.e., denominator of Geometric Mean calculation) for a second "t" routine.}

\item{...}{Arguments to embedded method (e.g., \code{glm} or \code{cor.test}).}
}
\value{
A list of results. Each element corresponds to a single result for a given value of gamma
}
\description{
Performs scale simulation over a range of values for gamma.
Dirichlet samples are reused for computational convenience.
}
