\name{aldex.clr-class}
\docType{class}

\alias{aldex.clr-class}

\title{The aldex.clr class}

\description{
  The aldex.clr S4 class is a class which stores the data generated by the aldex.clr method.
}

\section{Methods}{
  In the code below, \code{x} is an \code{aldex.clr} object, and \code{i},
  is a positive integer.
  There are N samples, D features, and M Monte-Carlo instances.
  \describe{
    \item{\code{getMonteCarloInstances(x)}}{
      Returns the clr transformed Monte Carlo Dirichlet instances as a list where
      each list entry is a single sample containing a D x M matrix.
    }
    \item{\code{getSampleIDs(x)}}{
      Returns the names of the samples. These can be used to access the
      original reads for a given sample, as in \code{x@reads\$sampleID}
      (if the reads are a data frame).
    }
    \item{\code{getFeatureNames(x)}}{
      Returns the names of the \code{keys}. These can be used to subset the
      data rows.
    }
    \item{\code{getFeatures(x)}}{
      Returns the clr transformed values for the features in the first sample.
    }
    \item{\code{numFeatures(x)}}{
      Returns the number of features that were non-0 in at least one sample.
    }
    \item{\code{numMCInstances(x)}}{
      Returns the number of Monte-Carlo instances.
    }
    \item{\code{getReads(x)}}{
      Returns the input data as used by the method.
    }
    \item{\code{numConditions(x)}}{
      Returns the number of samples in the \code{conditions} analysis.
    }
    \item{\code{getMonteCarloReplicate(x, i)}}{
      Returns the D x M matrix containing the Monte-Carlo instances
      for one sample.
    }
    \item{\code{getMonteCarloSample(x, i)}}{
      Returns the N x D matrix containing  Monte-Carlo instance \code{i}
      for for all samples.
    }
  }
}

\details{
  An aldex.clr object contains the centre-log ratio transformed Monte Carlo
  Dirichlet instances derived from estimating the technical variance of the
  raw read count data. It is created by the \code{aldex.clr.function}, which
  is invoked by the aldex.clr method. It consists of eight slots:
  the reads, the condition information, the number of instances, the denominator,
  whether it was invoked as verbose, and if multi-cores was used, the
  Dirichlet Monte-Carlo probabilities, and the centre-log ratio transformed
  Monte Carlo probabilities. These can be accessed along with information
  about the length of some attributes.
}
\value{
    The aldex.clr object contains the raw data, the estimated probabilities drawn from a Dirichlet distribution, and the clr transformed values for each Monte-Carlo  instance. These can be accessed through getters outlined below.
}

\references{
  Please use the citation given by \code{citation(package="ALDEx")}.}
  \author{
      Greg Gloor, Ruth Grace Wong, Andrew Fernandes, Jia Rong Wu and Matt Links
      contributed to this code
  }
  \seealso{
    \code{\link{aldex.clr.function}}
  }

\examples{

    # The 'reads' data.frame or
    # SummarizedExperiment object should have
    # row and column names that are unique,
    # and looks like the following:
    #
    #              T1a T1b  T2  T3  N1  N2  Nx
    #   Gene_00001   0   0   2   0   0   1   0
    #   Gene_00002  20   8  12   5  19  26  14
    #   Gene_00003   3   0   2   0   0   0   1
    #   Gene_00004  75  84 241 149 271 257 188
    #   Gene_00005  10  16   4   0   4  10  10
    #   Gene_00006 129 126 451 223 243 149 209
    #       ... many more rows ...

    data(selex)
    #subset for efficiency
    selex <- selex[1201:1600,]
    conds <- c(rep("NS", 7), rep("S", 7))
    i=1

    # x is an object of type aldex.clr
    x <- aldex.clr(selex, conds, mc.samples = 2, denom="all", verbose = FALSE)

    # get reads plus uniform prior
    reads <- getReads(x)

    # get a list containing all of the clr transformed instances
    monteCarloInstances <- getMonteCarloInstances(x)

    # get a list containing all of the Monte-Carlo Dirichlet instances
    monteCarloDirInstances <- getDirichletInstances(x)

    # retrieve the clr transformed instances for sample i.
    monteCarloInstance <- getMonteCarloReplicate(x,i)

    # retrieve the Monte-Carlo Dirichlet instances for sample i.
    monteCarloDirInstance <- getDirichletReplicate(x,i)

    # retrieve the clr transformed instance i for all samples
    monteCarloSample <- getMonteCarloSample(x,i)

    # retrieve the Monte-Carlo Dirichlet instance i for all samples
    monteCarloDirSample <- getDirichletSample(x,i)

    # get sample names
    sampleIDs <- getSampleIDs(x)

    # get features
    features <- getFeatures(x)

    # get number of features with at least one count
    numFeatures <- numFeatures(x)

    # get number of Monte Carlo instances
    numInstances <- numMCInstances(x)

    # get names of features
    featureNames <- getFeatureNames(x)

    # get number of conditions
    conditions <- numConditions(x)

    # get the offset of the features in the log-ratio  denominator
    denom <- getDenom(x)

}

\keyword{classes}
\keyword{methods}

