% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{qtotalNormalized}
\alias{qtotalNormalized}
\title{Estimating size factors from the reads count table via ranking}
\usage{
qtotalNormalized(ma, qper = 0.95, qst = 0.1, qend = 0.95, qstep = 0.01,
  qbound = 0.05, mcut = 4, qcl = 1.5)
}
\arguments{
\item{ma}{a count matrix}

\item{qper}{quantile for assessing dispersion of data, default is 0.95, which serves to avoid outliers, should in (0,1]}

\item{qst}{start of quantile for estimating cv ratio, should be in [0,1], default is 0.1}

\item{qend}{end of quantile for estimating cv ratio, should be in [qbound,1-qbound], default is .95}

\item{qstep}{step of quantile for estimating cv ratio (sliding window), should be in (0,1], default is 0.01}

\item{qbound}{window size for estimating cv and shifted size factor, default is 0.05, a smaller window size is suitable if number of genes is large}

\item{mcut}{cutoff of mean from sliding window to avoid abnormal cv, should >=0, default is 4}

\item{qcl}{scale for outlier detection, should >=0, default is 1.5}
}
\value{
a vector with the estimates size factors, one element per column
}
\description{
Function of qtotal for esitmating size factors
}
\details{
Given a matrix of count data, this function esitmates the size
factors by qtotal method, which is based on assessing DE (CV) and ranking. The CV is estimated via sliding window.
}
\examples{

data(simuN5)
counts <- simuN5$counts
qtotalNormalized(counts)

}
