% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{callDEs}
\alias{callDEs}
\title{Testing the differential expression by counts difference}
\usage{
callDEs(object, adjmethod = "BH", useaFold = FALSE)
}
\arguments{
\item{object}{an \code{\link{ABSDataSet}} object.}

\item{adjmethod}{the method for adjusting p-value, default is 'BH'. For details, see \code{\link{p.adjust.methods}}.}

\item{useaFold}{switch for DE detection through fold-change, which will use a normal distribution (N(0,sd)) to test the significance of log2 fold-change. The sd is estimated through a quantile function of gamma distribution at \code{\link{callParameter}}.}
}
\value{
an \code{\link{ABSDataSet}} object with additional elements: shrinked log2 fold-change, pvalue and adjusted p-value,
denoted by foldChange pvalue and adj-pvalue, respectively. Use the \code{\link{results}} method to get access it.
}
\description{
Using NB distribution to calculate p-value for each gene as well as adjust p-value
}
\details{
This function firstly calls p-value used \code{\link{pnbinom}} to call pvalue based on sum of counts difference between two
groups or used \code{\link{pnorm}} to call pvalue via log2 fold-change, then adjusts the pvalues via \code{\link{p.adjust}} method. In addition, it also shrink the log2 fold-change towards a common dispersion
after pvalue calling.
}
\note{
this function should run after \code{\link{callParameter}}
}
\examples{

data(simuN5)
obj <- ABSDataSet(counts=simuN5$counts, groups=factor(simuN5$groups))
obj <- normalFactors(obj)
obj <- callParameter(obj)
obj <- callDEs(obj)
head(results(obj))
}

