/*
 * Decompiled with CFR 0.152.
 */
package com.gkano.bioinfo.vcf;

import com.gkano.bioinfo.var.Logger;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;

public class VariantEmbeddingLoader {
    private VariantEmbeddingLoader() {
    }

    public static Map<String, double[]> loadEmbeddings(String filePath) throws IOException {
        EmbeddingFormat format = VariantEmbeddingLoader.detectFormat(filePath);
        return VariantEmbeddingLoader.loadEmbeddings(filePath, format);
    }

    public static Map<String, double[]> loadEmbeddings(String filePath, EmbeddingFormat format) throws IOException {
        switch (format) {
            case TSV: {
                return VariantEmbeddingLoader.loadTSV(filePath);
            }
            case HUGGINGFACE: {
                return VariantEmbeddingLoader.loadHuggingFace(filePath);
            }
        }
        throw new IllegalArgumentException("Unsupported embedding format: " + String.valueOf((Object)format));
    }

    private static EmbeddingFormat detectFormat(String filePath) {
        String lower = filePath.toLowerCase();
        if (lower.endsWith(".gz")) {
            lower = lower.substring(0, lower.length() - 3);
        }
        if (lower.endsWith(".json")) {
            return EmbeddingFormat.HUGGINGFACE;
        }
        return EmbeddingFormat.TSV;
    }

    private static Map<String, double[]> loadTSV(String filePath) throws IOException {
        HashMap<String, double[]> embeddings = new HashMap<String, double[]>();
        int embeddingDim = -1;
        int lineNum = 0;
        try (BufferedReader reader = VariantEmbeddingLoader.createReader(filePath);){
            String line;
            while ((line = reader.readLine()) != null) {
                ++lineNum;
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                String[] parts = line.split("\t");
                if (parts.length < 2) {
                    Logger.warn(VariantEmbeddingLoader.class, "Skipping malformed line " + lineNum + ": insufficient columns");
                    continue;
                }
                String variantKey = parts[0].trim();
                int dim = parts.length - 1;
                if (embeddingDim < 0) {
                    embeddingDim = dim;
                } else if (dim != embeddingDim) {
                    Logger.warn(VariantEmbeddingLoader.class, "Skipping line " + lineNum + ": dimension mismatch (expected " + embeddingDim + ", got " + dim + ")");
                    continue;
                }
                double[] embedding = new double[dim];
                boolean valid = true;
                for (int i = 0; i < dim; ++i) {
                    try {
                        embedding[i] = Double.parseDouble(parts[i + 1].trim());
                        continue;
                    }
                    catch (NumberFormatException e) {
                        Logger.warn(VariantEmbeddingLoader.class, "Skipping line " + lineNum + ": invalid number at column " + (i + 2));
                        valid = false;
                        break;
                    }
                }
                if (!valid) continue;
                embeddings.put(variantKey, embedding);
            }
        }
        Logger.info(VariantEmbeddingLoader.class, "Loaded " + embeddings.size() + " embeddings with dimension " + embeddingDim);
        return embeddings;
    }

    private static Map<String, double[]> loadHuggingFace(String filePath) throws IOException {
        HashMap<String, double[]> embeddings = new HashMap<String, double[]>();
        StringBuilder content = new StringBuilder();
        try (BufferedReader reader = VariantEmbeddingLoader.createReader(filePath);){
            String line;
            while ((line = reader.readLine()) != null) {
                content.append(line);
            }
        }
        String json = content.toString().trim();
        if (json.contains("\"variants\"")) {
            VariantEmbeddingLoader.parseHuggingFaceNested(json, embeddings);
        } else {
            VariantEmbeddingLoader.parseHuggingFaceFlat(json, embeddings);
        }
        if (!embeddings.isEmpty()) {
            int dim = ((double[])embeddings.values().iterator().next()).length;
            Logger.info(VariantEmbeddingLoader.class, "Loaded " + embeddings.size() + " embeddings with dimension " + dim);
        }
        return embeddings;
    }

    private static void parseHuggingFaceNested(String json, Map<String, double[]> embeddings) {
        int objEnd;
        int objStart;
        int variantsStart = json.indexOf("\"variants\"");
        if (variantsStart < 0) {
            return;
        }
        int arrayStart = json.indexOf(91, variantsStart);
        if (arrayStart < 0) {
            return;
        }
        int arrayEnd = VariantEmbeddingLoader.findMatchingBracket(json, arrayStart, '[', ']');
        if (arrayEnd < 0) {
            return;
        }
        String variantsArray = json.substring(arrayStart + 1, arrayEnd);
        int pos = 0;
        while (pos < variantsArray.length() && (objStart = variantsArray.indexOf(123, pos)) >= 0 && (objEnd = VariantEmbeddingLoader.findMatchingBracket(variantsArray, objStart, '{', '}')) >= 0) {
            String obj = variantsArray.substring(objStart, objEnd + 1);
            VariantEmbeddingLoader.parseVariantObject(obj, embeddings);
            pos = objEnd + 1;
        }
    }

    private static void parseVariantObject(String obj, Map<String, double[]> embeddings) {
        String id = VariantEmbeddingLoader.extractJsonString(obj, "id");
        if (id == null) {
            return;
        }
        double[] embedding = VariantEmbeddingLoader.extractJsonArray(obj, "embedding");
        if (embedding == null) {
            return;
        }
        embeddings.put(id, embedding);
    }

    private static void parseHuggingFaceFlat(String json, Map<String, double[]> embeddings) {
        int keyEnd;
        int keyStart;
        if ((json = json.trim()).startsWith("{")) {
            json = json.substring(1);
        }
        if (json.endsWith("}")) {
            json = json.substring(0, json.length() - 1);
        }
        int pos = 0;
        while (pos < json.length() && (keyStart = json.indexOf(34, pos)) >= 0 && (keyEnd = json.indexOf(34, keyStart + 1)) >= 0) {
            int arrayEnd;
            String key = json.substring(keyStart + 1, keyEnd);
            int arrayStart = json.indexOf(91, keyEnd);
            if (arrayStart < 0 || (arrayEnd = VariantEmbeddingLoader.findMatchingBracket(json, arrayStart, '[', ']')) < 0) break;
            String arrayStr = json.substring(arrayStart + 1, arrayEnd);
            double[] embedding = VariantEmbeddingLoader.parseDoubleArray(arrayStr);
            if (embedding != null && embedding.length > 0) {
                embeddings.put(key, embedding);
            }
            pos = arrayEnd + 1;
        }
    }

    private static String extractJsonString(String json, String key) {
        String search = "\"" + key + "\"";
        int keyPos = json.indexOf(search);
        if (keyPos < 0) {
            return null;
        }
        int colonPos = json.indexOf(58, keyPos + search.length());
        if (colonPos < 0) {
            return null;
        }
        int valueStart = json.indexOf(34, colonPos);
        if (valueStart < 0) {
            return null;
        }
        int valueEnd = json.indexOf(34, valueStart + 1);
        if (valueEnd < 0) {
            return null;
        }
        return json.substring(valueStart + 1, valueEnd);
    }

    private static double[] extractJsonArray(String json, String key) {
        String search = "\"" + key + "\"";
        int keyPos = json.indexOf(search);
        if (keyPos < 0) {
            return null;
        }
        int arrayStart = json.indexOf(91, keyPos);
        if (arrayStart < 0) {
            return null;
        }
        int arrayEnd = VariantEmbeddingLoader.findMatchingBracket(json, arrayStart, '[', ']');
        if (arrayEnd < 0) {
            return null;
        }
        String arrayStr = json.substring(arrayStart + 1, arrayEnd);
        return VariantEmbeddingLoader.parseDoubleArray(arrayStr);
    }

    private static double[] parseDoubleArray(String arrayStr) {
        String[] parts = arrayStr.split(",");
        double[] result = new double[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            try {
                result[i] = Double.parseDouble(parts[i].trim());
                continue;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return result;
    }

    private static int findMatchingBracket(String s, int start, char open, char close) {
        int depth = 0;
        for (int i = start; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == open) {
                ++depth;
                continue;
            }
            if (c != close || --depth != 0) continue;
            return i;
        }
        return -1;
    }

    private static BufferedReader createReader(String filePath) throws IOException {
        InputStream is = new FileInputStream(filePath);
        if (filePath.toLowerCase().endsWith(".gz")) {
            is = new GZIPInputStream(is);
        }
        return new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
    }

    public static int getEmbeddingDimension(Map<String, double[]> embeddings) {
        if (embeddings == null || embeddings.isEmpty()) {
            return -1;
        }
        return embeddings.values().iterator().next().length;
    }

    public static enum EmbeddingFormat {
        TSV,
        HUGGINGFACE;

    }
}

