/*
 * Decompiled with CFR 0.152.
 */
package com.gkano.bioinfo.javautils;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.gkano.bioinfo.var.GeneralTools;
import com.gkano.bioinfo.var.Logger;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

@Parameters(commandDescription="FASTA2TREE")
public class UtilFASTA2TREE {
    @Parameter(names={"--help"}, help=true)
    private boolean help;
    @Parameter(names={"-v", "--verbose"})
    private boolean verbose = false;
    @Parameter(description="<positional input files>")
    private List<String> positionalInputFiles = new ArrayList<String>();
    @Parameter(names={"-i", "--input"}, description="FASTA input file(s)", variableArity=true)
    private List<String> namedInputFiles = new ArrayList<String>();
    @Parameter(names={"-o", "--output"}, description="Tree output file")
    private String outputFile;
    @Parameter(names={"--isFastq", "-q"}, description="Input is FASTQ (default: false)")
    private boolean isFastq = false;
    @Parameter(names={"--kmerSize", "-k"}, description="Kmer size (default: 4)")
    private Integer k = 4;
    @Parameter(names={"--normalize", "-n"})
    private boolean normalize = false;
    @Parameter(names={"--numberOfThreads", "-t"})
    private int numOfThreads = 1;

    public static String getUtilName() {
        return "FASTA2DIST";
    }

    public void go() {
        try {
            PrintStream ops = GeneralTools.getPrintStreamOrExit(this.outputFile, this);
            if (ops != null) {
                ops.close();
            }
        }
        catch (Exception e) {
            Logger.error(this, e.getMessage());
        }
    }
}

