## ----example1,eval=TRUE, results="hide", message=FALSE, warning=FALSE---------
require(dmGsea)
#generating example data
annopkg <- "IlluminaHumanMethylation450kanno.ilmn12.hg19"
anno <- minfi::getAnnotation(eval(annopkg))
#Use a subset of the data in the example to speed up execution
anno <- anno[1:10000,]
probe.p <- data.frame(Name=rownames(anno),p=runif(nrow(anno)))
probe.p$p[1:500] <- probe.p$p[1:500]/100000
Data4cor <- matrix(runif(nrow(probe.p)*100),ncol=100)
rownames(Data4cor) <- rownames(anno)

#geneset enrichment analysis with threshold based method
#for top ranked 1000 genes
gsGene(probe.p <- probe.p,Data4Cor=Data4cor,arrayType="450K",nTopGene=1000,
    outGenep=TRUE, method="Threshold",gSetName="KEGG",species="Human",
    outfile="gs1",ncore=1)
file.remove("gs1_KEGG_KEGG.csv")

## ----example2, eval=TRUE, results="hide", message=FALSE, warning=FALSE--------
#generate example dataset
kegg <- getKEGG(species="Human")
gene1 <- unique(as.vector(unlist(kegg[1:5])))
gene2 <- unique(as.vector(unlist(kegg[6:length(kegg)])))
gene1 <- rep(gene1,sample(1:10,length(gene1),replace=TRUE))
gene2 <- rep(gene2,sample(1:10,length(gene2),replace=TRUE))
p11 <- runif(length(gene1))*(1e-3)
p2 <- runif(length(gene2))
geneid <- c(gene1,gene2)
p <- c(p11,p2)
Name <- paste0("cg",1:length(p))
probe.p <- data.frame(Name=Name,p=p)
GeneProbeTable <- data.frame(Name=Name,entrezid=geneid)
dat <- matrix(runif(length(p)*100),ncol=100)
rownames(dat) <- Name

#enrichment analysis
gsGene(probe.p=probe.p,Data4Cor=dat,GeneProbeTable=GeneProbeTable,
        method="Threshold",gSetName="KEGG",species="Human",outfile="gs5",
        ncore=1)
file.remove("gs5_KEGG_KEGG.csv")

## ----example3, eval=TRUE, results="hide", message=FALSE, warning=FALSE--------
#generatin example dataset
userGeneset <- getKEGG(species="Human")

#enrichment analysis
gsGene(probe.p=probe.p,Data4Cor=dat,GeneProbeTable=GeneProbeTable,
        method="Threshold",geneSet=userGeneset,species="Human",outfile="gs7",
        ncore=1)
file.remove("gs7_userSet_userSet.csv")

## ----example4, eval=TRUE, results="hide", message=FALSE, warning=FALSE--------
#generatin example dataset
kegg <- getKEGG(species="Human")
gene <- unique(as.vector(unlist(kegg)))
p <- runif(length(gene))
names(p) <- gene
stats <- -log(p)*sample(c(1,-1),length(p),replace=TRUE)

#traditional GSEA analysis, enrichment toward higher or lower end of statstics
stats <- sort(stats,decr=TRUE)
gsRank(stats=stats,gSetName="KEGG",scoreType="std",outfile="gs9",nperm=1e4,
    ncore=1)
file.remove("gs9_KEGG_KEGG.csv")
file.remove("gsGene_genep.csv")

#enrichment of genes with higher statistics
stats <- sort(abs(stats),decr=TRUE)

## ----session info-------------------------------------------------------------
sessionInfo() 

