## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>",
    fig.width = 10
)

## ----include = FALSE, eval=FALSE----------------------------------------------
# rmarkdown::render("Visualization-of-SIP-proteomic-result.Rmd", output_dir = "../doc/")

## ----setup--------------------------------------------------------------------
library(Aerith)

## -----------------------------------------------------------------------------
demo_file <- system.file("extdata", "demo.psm.txt", package = "Aerith")
summaryStats <- summaryPSMsipPCT(demo_file)
print(summaryStats)

## -----------------------------------------------------------------------------
demo_file <- system.file("extdata", "demo.psm.txt", package = "Aerith")
p <- plotPSMsipPCT(demo_file)
p

## ----session-info-------------------------------------------------------------
sessionInfo()

