/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SingletonAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.SingletonList;
import org.biojava.utils.StaticMemberPlaceHolder;

public class IntegerAlphabet
implements Alphabet,
Serializable {
    private static final IntegerAlphabet INSTANCE = new IntegerAlphabet();
    static /* synthetic */ Class class$org$biojava$bio$symbol$IntegerAlphabet;

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean contains(Symbol symbol) {
        return symbol instanceof IntegerSymbol;
    }

    public static SymbolList fromArray(int[] nArray) {
        return new IntegerArray(nArray);
    }

    public List getAlphabets() {
        return new SingletonList(this);
    }

    public Symbol getAmbiguity(Set set) throws IllegalSymbolException {
        throw new BioError("Unimplemneted method");
    }

    public Annotation getAnnotation() {
        return Annotation.EMPTY_ANNOTATION;
    }

    public static IntegerAlphabet getInstance() {
        return INSTANCE;
    }

    public String getName() {
        return "Alphabet of all integers.";
    }

    public SymbolParser getParser(String string) {
        throw new NoSuchElementException("No parsers supported by IntegerAlphabet yet");
    }

    public IntegerSymbol getSymbol(int n) {
        return new IntegerSymbol(n);
    }

    public Symbol getSymbol(List list) throws IllegalSymbolException {
        throw new BioError("Unimplemneted method");
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    public void validate(Symbol symbol) throws IllegalSymbolException {
        if (!this.contains(symbol)) {
            throw new IllegalSymbolException("Only symbols of type IntegerAlphabet.IntegerSymbol are valid for this alphabet.\n(" + symbol.getClass() + ") " + symbol.getName());
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        try {
            return new StaticMemberPlaceHolder((class$org$biojava$bio$symbol$IntegerAlphabet != null ? class$org$biojava$bio$symbol$IntegerAlphabet : (class$org$biojava$bio$symbol$IntegerAlphabet = IntegerAlphabet.class$("org.biojava.bio.symbol.IntegerAlphabet"))).getField("INSTANCE"));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new NotSerializableException(noSuchFieldException.getMessage());
        }
    }

    public static class IntegerSymbol
    implements AtomicSymbol,
    Serializable {
        private final int val;
        private final Alphabet matches;

        protected IntegerSymbol(int n) {
            this.val = n;
            this.matches = new SingletonAlphabet(this);
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
        }

        public Annotation getAnnotation() {
            return Annotation.EMPTY_ANNOTATION;
        }

        public Set getBases() {
            return Collections.singleton(this);
        }

        public Alphabet getMatches() {
            return this.matches;
        }

        public String getName() {
            return String.valueOf(this.val);
        }

        public List getSymbols() {
            return new SingletonList(this);
        }

        public char getToken() {
            return '#';
        }

        public int intValue() {
            return this.val;
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
        }
    }

    private static class IntegerArray
    extends AbstractSymbolList
    implements Serializable {
        private final int[] iArray;

        public IntegerArray(int[] nArray) {
            this.iArray = nArray;
        }

        public Alphabet getAlphabet() {
            return INSTANCE;
        }

        public int length() {
            return this.iArray.length;
        }

        public Symbol symbolAt(int n) {
            return new IntegerSymbol(this.iArray[n - 1]);
        }
    }
}

