/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.AbstractFeatureHolder;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.bytecode.ByteCode;
import org.biojava.utils.bytecode.CodeClass;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.CodeMethod;
import org.biojava.utils.bytecode.CodeUtils;
import org.biojava.utils.bytecode.GeneratedClassLoader;
import org.biojava.utils.bytecode.GeneratedCodeClass;
import org.biojava.utils.bytecode.GeneratedCodeMethod;
import org.biojava.utils.bytecode.Instruction;
import org.biojava.utils.bytecode.InstructionVector;
import org.biojava.utils.bytecode.IntrospectedCodeClass;
import org.biojava.utils.bytecode.SimpleCodeMethod;

public class ProjectedFeatureHolder
extends AbstractFeatureHolder {
    private final FeatureHolder wrapped;
    private final FeatureHolder parent;
    private final int translate;
    private FeatureHolder projectedFeatures;
    private boolean oppositeStrand;
    private FeatureFilter filter;
    private ChangeListener underlyingFeaturesChange;
    private static Map _projectionClasses;
    private static int seed;
    private static GeneratedClassLoader loader;
    static /* synthetic */ Class class$org$biojava$bio$seq$Feature;
    static /* synthetic */ Class class$org$biojava$bio$seq$impl$ProjectedFeatureWrapper;
    static /* synthetic */ Class class$org$biojava$bio$seq$StrandedFeature;
    static /* synthetic */ Class class$org$biojava$bio$seq$impl$ProjectedStrandedFeatureWrapper;
    static /* synthetic */ Class class$org$biojava$bio$seq$ProjectedFeatureHolder;

    static {
        seed = 1;
        _projectionClasses = new HashMap();
        _projectionClasses.put(class$org$biojava$bio$seq$Feature != null ? class$org$biojava$bio$seq$Feature : (class$org$biojava$bio$seq$Feature = ProjectedFeatureHolder.class$("org.biojava.bio.seq.Feature")), class$org$biojava$bio$seq$impl$ProjectedFeatureWrapper != null ? class$org$biojava$bio$seq$impl$ProjectedFeatureWrapper : (class$org$biojava$bio$seq$impl$ProjectedFeatureWrapper = ProjectedFeatureHolder.class$("org.biojava.bio.seq.impl.ProjectedFeatureWrapper")));
        _projectionClasses.put(class$org$biojava$bio$seq$StrandedFeature != null ? class$org$biojava$bio$seq$StrandedFeature : (class$org$biojava$bio$seq$StrandedFeature = ProjectedFeatureHolder.class$("org.biojava.bio.seq.StrandedFeature")), class$org$biojava$bio$seq$impl$ProjectedStrandedFeatureWrapper != null ? class$org$biojava$bio$seq$impl$ProjectedStrandedFeatureWrapper : (class$org$biojava$bio$seq$impl$ProjectedStrandedFeatureWrapper = ProjectedFeatureHolder.class$("org.biojava.bio.seq.impl.ProjectedStrandedFeatureWrapper")));
        loader = new GeneratedClassLoader((class$org$biojava$bio$seq$impl$ProjectedFeatureWrapper != null ? class$org$biojava$bio$seq$impl$ProjectedFeatureWrapper : (class$org$biojava$bio$seq$impl$ProjectedFeatureWrapper = ProjectedFeatureHolder.class$("org.biojava.bio.seq.impl.ProjectedFeatureWrapper"))).getClassLoader());
    }

    public ProjectedFeatureHolder(FeatureHolder featureHolder, FeatureFilter featureFilter, FeatureHolder featureHolder2, int n, boolean bl) {
        this.wrapped = featureHolder;
        this.parent = featureHolder2;
        this.translate = n;
        this.oppositeStrand = bl;
        this.filter = featureFilter;
        this.underlyingFeaturesChange = new ChangeListener(){

            public void postChange(ChangeEvent changeEvent) {
                ProjectedFeatureHolder.this.projectedFeatures = null;
                if (ProjectedFeatureHolder.this.changeSupport != null) {
                    ProjectedFeatureHolder.this.changeSupport.firePostChangeEvent(new ChangeEvent(this, FeatureHolder.FEATURES, changeEvent.getChange(), changeEvent.getPrevious(), changeEvent));
                }
            }

            public void preChange(ChangeEvent changeEvent) throws ChangeVetoException {
                if (ProjectedFeatureHolder.this.changeSupport != null) {
                    ProjectedFeatureHolder.this.changeSupport.firePreChangeEvent(new ChangeEvent(this, FeatureHolder.FEATURES, changeEvent.getChange(), changeEvent.getPrevious(), changeEvent));
                }
            }
        };
        this.wrapped.addChangeListener(this.underlyingFeaturesChange);
    }

    public ProjectedFeatureHolder(FeatureHolder featureHolder, FeatureHolder featureHolder2, int n, boolean bl) {
        this(featureHolder, null, featureHolder2, n, bl);
    }

    static /* synthetic */ FeatureHolder access$0(ProjectedFeatureHolder projectedFeatureHolder) {
        return projectedFeatureHolder.projectedFeatures;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean containsFeature(Feature feature) {
        return this.getProjectedFeatures().containsFeature(feature);
    }

    public int countFeatures() {
        return this.getProjectedFeatures().countFeatures();
    }

    public Iterator features() {
        return this.getProjectedFeatures().features();
    }

    public FeatureHolder filter(FeatureFilter featureFilter, boolean bl) {
        return this.getProjectedFeatures().filter(featureFilter, bl);
    }

    public FeatureHolder getParent() {
        return this.parent;
    }

    protected FeatureHolder getProjectedFeatures() {
        if (this.projectedFeatures == null) {
            FeatureHolder featureHolder = this.wrapped;
            if (this.filter != null) {
                featureHolder = featureHolder.filter(this.filter, false);
            }
            SimpleFeatureHolder simpleFeatureHolder = new SimpleFeatureHolder();
            Iterator iterator = featureHolder.features();
            while (iterator.hasNext()) {
                Feature feature = (Feature)iterator.next();
                Feature feature2 = this.projectFeature(feature);
                try {
                    simpleFeatureHolder.addFeature(feature2);
                }
                catch (ChangeVetoException changeVetoException) {
                    throw new BioError(changeVetoException, "Assertion failure: Should be able to manipulate this FeatureHolder");
                }
            }
            this.projectedFeatures = simpleFeatureHolder;
        }
        return this.projectedFeatures;
    }

    public Location getProjectedLocation(Location location) {
        if (this.oppositeStrand) {
            if (location.isContiguous()) {
                return new RangeLocation(this.translate - location.getMax(), this.translate - location.getMin());
            }
            Location location2 = Location.empty;
            Iterator iterator = location.blockIterator();
            while (iterator.hasNext()) {
                Location location3 = (Location)iterator.next();
                location2 = location2.union(new RangeLocation(this.translate - location.getMax(), this.translate - location.getMin()));
            }
            return location2;
        }
        return location.translate(this.translate);
    }

    private static Class getProjectionClass(Class clazz) {
        Class clazz2 = (Class)_projectionClasses.get(clazz);
        if (clazz2 == null) {
            try {
                Class clazz3 = class$org$biojava$bio$seq$impl$ProjectedFeatureWrapper != null ? class$org$biojava$bio$seq$impl$ProjectedFeatureWrapper : (class$org$biojava$bio$seq$impl$ProjectedFeatureWrapper = ProjectedFeatureHolder.class$("org.biojava.bio.seq.impl.ProjectedFeatureWrapper"));
                if ((class$org$biojava$bio$seq$StrandedFeature != null ? class$org$biojava$bio$seq$StrandedFeature : (class$org$biojava$bio$seq$StrandedFeature = ProjectedFeatureHolder.class$("org.biojava.bio.seq.StrandedFeature"))).isAssignableFrom(clazz)) {
                    clazz3 = class$org$biojava$bio$seq$impl$ProjectedStrandedFeatureWrapper != null ? class$org$biojava$bio$seq$impl$ProjectedStrandedFeatureWrapper : (class$org$biojava$bio$seq$impl$ProjectedStrandedFeatureWrapper = ProjectedFeatureHolder.class$("org.biojava.bio.seq.impl.ProjectedStrandedFeatureWrapper"));
                }
                StringTokenizer stringTokenizer = new StringTokenizer(clazz.getName(), ".");
                String string = stringTokenizer.nextToken();
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                }
                CodeClass codeClass = IntrospectedCodeClass.forClass(clazz3);
                CodeClass codeClass2 = IntrospectedCodeClass.forClass(clazz);
                GeneratedCodeClass generatedCodeClass = new GeneratedCodeClass("org.biojava.bio.seq.impl.Projection_" + string + "_" + seed++, codeClass, new CodeClass[]{codeClass2}, 33);
                ArrayList<CodeClass> arrayList = new ArrayList<CodeClass>();
                arrayList.add(clazz3 == (class$org$biojava$bio$seq$impl$ProjectedStrandedFeatureWrapper != null ? class$org$biojava$bio$seq$impl$ProjectedStrandedFeatureWrapper : (class$org$biojava$bio$seq$impl$ProjectedStrandedFeatureWrapper = ProjectedFeatureHolder.class$("org.biojava.bio.seq.impl.ProjectedStrandedFeatureWrapper"))) ? IntrospectedCodeClass.forClass(class$org$biojava$bio$seq$StrandedFeature != null ? class$org$biojava$bio$seq$StrandedFeature : (class$org$biojava$bio$seq$StrandedFeature = ProjectedFeatureHolder.class$("org.biojava.bio.seq.StrandedFeature"))) : IntrospectedCodeClass.forClass(class$org$biojava$bio$seq$Feature != null ? class$org$biojava$bio$seq$Feature : (class$org$biojava$bio$seq$Feature = ProjectedFeatureHolder.class$("org.biojava.bio.seq.Feature"))));
                arrayList.add(IntrospectedCodeClass.forClass(class$org$biojava$bio$seq$ProjectedFeatureHolder != null ? class$org$biojava$bio$seq$ProjectedFeatureHolder : (class$org$biojava$bio$seq$ProjectedFeatureHolder = ProjectedFeatureHolder.class$("org.biojava.bio.seq.ProjectedFeatureHolder"))));
                SimpleCodeMethod simpleCodeMethod = new SimpleCodeMethod("<init>", codeClass, CodeUtils.TYPE_VOID, arrayList, 1);
                SimpleCodeMethod simpleCodeMethod2 = new SimpleCodeMethod("getViewedFeature", codeClass, IntrospectedCodeClass.forClass(class$org$biojava$bio$seq$Feature != null ? class$org$biojava$bio$seq$Feature : (class$org$biojava$bio$seq$Feature = ProjectedFeatureHolder.class$("org.biojava.bio.seq.Feature"))), new ArrayList(), 1);
                GeneratedCodeMethod generatedCodeMethod = generatedCodeClass.createMethod("<init>", IntrospectedCodeClass.forClass(Void.TYPE), new CodeClass[]{codeClass2, IntrospectedCodeClass.forClass(class$org$biojava$bio$seq$ProjectedFeatureHolder != null ? class$org$biojava$bio$seq$ProjectedFeatureHolder : (class$org$biojava$bio$seq$ProjectedFeatureHolder = ProjectedFeatureHolder.class$("org.biojava.bio.seq.ProjectedFeatureHolder")))}, 1);
                InstructionVector instructionVector = new InstructionVector();
                instructionVector.add(ByteCode.make_aload(generatedCodeMethod.getThis()));
                instructionVector.add(ByteCode.make_aload(generatedCodeMethod.getVariable(0)));
                instructionVector.add(ByteCode.make_aload(generatedCodeMethod.getVariable(1)));
                instructionVector.add(ByteCode.make_invokespecial(simpleCodeMethod));
                instructionVector.add(ByteCode.make_return());
                generatedCodeClass.setCodeGenerator(generatedCodeMethod, instructionVector);
                Iterator iterator = codeClass2.getMethods().iterator();
                while (iterator.hasNext()) {
                    CodeMethod codeMethod = (CodeMethod)iterator.next();
                    if (codeClass.getMethodsByName(codeMethod.getName()).size() > 0 || codeMethod.numParameters() > 0) continue;
                    GeneratedCodeMethod generatedCodeMethod2 = generatedCodeClass.createMethod(codeMethod.getName(), codeMethod.getReturnType(), CodeUtils.EMPTY_LIST, 1);
                    instructionVector = new InstructionVector();
                    instructionVector.add(ByteCode.make_aload(generatedCodeMethod2.getThis()));
                    instructionVector.add(ByteCode.make_invokevirtual(simpleCodeMethod2));
                    instructionVector.add(ByteCode.make_invokeinterface(codeMethod));
                    Instruction instruction = ByteCode.make_areturn();
                    CodeClass codeClass3 = generatedCodeMethod2.getReturnType();
                    if (codeClass3 == CodeUtils.TYPE_VOID) {
                        instruction = ByteCode.make_return();
                    } else if (codeClass3 == CodeUtils.TYPE_INT || codeClass3 == CodeUtils.TYPE_SHORT || codeClass3 == CodeUtils.TYPE_CHAR || codeClass3 == CodeUtils.TYPE_BYTE) {
                        instruction = ByteCode.make_ireturn();
                    } else if (codeClass3 == CodeUtils.TYPE_LONG) {
                        instruction = ByteCode.make_lreturn();
                    } else if (codeClass3 == CodeUtils.TYPE_FLOAT) {
                        instruction = ByteCode.make_freturn();
                    } else if (codeClass3 == CodeUtils.TYPE_DOUBLE) {
                        instruction = ByteCode.make_dreturn();
                    }
                    instructionVector.add(instruction);
                    generatedCodeClass.setCodeGenerator(generatedCodeMethod2, instructionVector);
                }
                clazz2 = loader.defineClass(generatedCodeClass);
                _projectionClasses.put(clazz, clazz2);
            }
            catch (CodeException codeException) {
                throw new BioError(codeException);
            }
        }
        return clazz2;
    }

    public int getTranslation() {
        return this.translate;
    }

    public boolean isOppositeStrand() {
        return this.oppositeStrand;
    }

    protected Feature projectFeature(Feature feature) {
        Class<?> clazz = feature.getClass();
        Class<?>[] classArray = clazz.getInterfaces();
        Class clazz2 = class$org$biojava$bio$seq$Feature != null ? class$org$biojava$bio$seq$Feature : (class$org$biojava$bio$seq$Feature = ProjectedFeatureHolder.class$("org.biojava.bio.seq.Feature"));
        int n = classArray.length - 1;
        while (n >= 0) {
            if ((class$org$biojava$bio$seq$Feature != null ? class$org$biojava$bio$seq$Feature : ProjectedFeatureHolder.class$("org.biojava.bio.seq.Feature")).isAssignableFrom(classArray[n])) {
                clazz2 = classArray[n];
                break;
            }
            --n;
        }
        Class clazz3 = ProjectedFeatureHolder.getProjectionClass(clazz2);
        Class[] classArray2 = new Class[]{clazz2, class$org$biojava$bio$seq$ProjectedFeatureHolder != null ? class$org$biojava$bio$seq$ProjectedFeatureHolder : (class$org$biojava$bio$seq$ProjectedFeatureHolder = ProjectedFeatureHolder.class$("org.biojava.bio.seq.ProjectedFeatureHolder"))};
        try {
            Constructor constructor = clazz3.getConstructor(classArray2);
            Object[] objectArray = new Object[]{feature, this};
            return (Feature)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new BioError(exception, "Assertion failed: Couldn't instantiate proxy " + clazz3.getName());
        }
    }
}

