/*
 * Decompiled with CFR 0.152.
 */
package eponine.model;

import eponine.model.BasisFunctionWithHistory;
import eponine.model.BundleConstraint;
import eponine.model.ConstraintBasisFunction;
import eponine.model.ModelTools;
import eponine.model.PositionedConstraint;
import eponine.model.WeightMatrixConstraint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.OrderNDistribution;
import org.biojava.bio.dist.SimpleDistributionTrainerContext;
import org.biojava.bio.dp.SimpleWeightMatrix;
import org.biojava.bio.dp.WeightMatrix;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.FundamentalAtomicSymbol;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.Changeable;
import stats.glm.BasisFunction;
import stats.glm.BasisSource;
import stats.glm.SLMTrainingContext;

public class MakeHigherOrderBasisSource
extends FundamentalAtomicSymbol
implements BasisSource {
    private double nullModelWeighting = 3.0;
    private int sampleCounts = 71;
    private String name = "2ndorder";

    public MakeHigherOrderBasisSource() {
        super("2ndorder", ' ', Annotation.EMPTY_ANNOTATION);
    }

    public void setNullModelWeighting(double d) {
        this.nullModelWeighting = d;
    }

    public void setSampleCounts(int n) {
        this.sampleCounts = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public BasisFunction next(SLMTrainingContext sLMTrainingContext) {
        Object object;
        Object object2;
        List list = sLMTrainingContext.getBasisList();
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object2 = (BasisFunction)iterator.next();
            object = ModelTools.removeHistory((BasisFunction)object2);
            if (!(object instanceof ConstraintBasisFunction)) continue;
            PositionedConstraint positionedConstraint = (PositionedConstraint)((ConstraintBasisFunction)object).getConstraint();
            int n2 = 1;
            if (positionedConstraint.getConstraint() instanceof BundleConstraint) {
                n2 = ((BundleConstraint)positionedConstraint.getConstraint()).getConstraints().size();
            }
            hashMap.put(object2, new Integer(n2));
            n += n2;
        }
        n = (int)Math.ceil((double)n * Math.random());
        object2 = hashMap.entrySet().iterator();
        while (object2.hasNext()) {
            object = (Map.Entry)object2.next();
            int n3 = (Integer)object.getValue();
            if ((n -= n3) > 0) continue;
            BasisFunction basisFunction = (BasisFunction)object.getKey();
            PositionedConstraint positionedConstraint = (PositionedConstraint)ModelTools.getConstraint(basisFunction);
            if (n3 == 1) {
                WeightMatrixConstraint weightMatrixConstraint = (WeightMatrixConstraint)positionedConstraint.getConstraint();
                if ((weightMatrixConstraint = this.sampleWeightMatrixConstraint(weightMatrixConstraint)) == null) {
                    return null;
                }
                return new BasisFunctionWithHistory(new ConstraintBasisFunction(new PositionedConstraint(weightMatrixConstraint, positionedConstraint.getPosition(), positionedConstraint.getDistribution(), positionedConstraint.isMaximum())), Collections.singleton(basisFunction), this, sLMTrainingContext.getCurrentCycle());
            }
            ArrayList<PositionedConstraint> arrayList = new ArrayList<PositionedConstraint>(((BundleConstraint)positionedConstraint.getConstraint()).getConstraints());
            PositionedConstraint positionedConstraint2 = (PositionedConstraint)arrayList.get(-n);
            WeightMatrixConstraint weightMatrixConstraint = (WeightMatrixConstraint)positionedConstraint2.getConstraint();
            if ((weightMatrixConstraint = this.sampleWeightMatrixConstraint(weightMatrixConstraint)) == null) {
                return null;
            }
            arrayList.set(-n, new PositionedConstraint(weightMatrixConstraint, positionedConstraint2.getPosition(), positionedConstraint2.getDistribution(), positionedConstraint2.isMaximum()));
            return new BasisFunctionWithHistory(new ConstraintBasisFunction(new PositionedConstraint(new BundleConstraint(arrayList), positionedConstraint.getPosition(), positionedConstraint.getDistribution(), positionedConstraint.isMaximum())), Collections.singleton(basisFunction), this, sLMTrainingContext.getCurrentCycle());
        }
        System.out.println("totalProb exceeded");
        return null;
    }

    private WeightMatrixConstraint sampleWeightMatrixConstraint(WeightMatrixConstraint weightMatrixConstraint) {
        WeightMatrix weightMatrix = weightMatrixConstraint.getWeightMatrix();
        if (weightMatrix.getAlphabet() != DNATools.getDNA()) {
            return null;
        }
        try {
            return new WeightMatrixConstraint(this.makeSecondOrderWM(weightMatrix), 0.0);
        }
        catch (Exception exception) {
            throw new BioError(exception);
        }
    }

    private WeightMatrix makeSecondOrderWM(WeightMatrix weightMatrix) {
        try {
            Changeable changeable;
            Object object;
            FiniteAlphabet finiteAlphabet = (FiniteAlphabet)weightMatrix.getAlphabet();
            Alphabet alphabet = AlphabetManager.getCrossProductAlphabet(Collections.nCopies(2, finiteAlphabet));
            SimpleWeightMatrix simpleWeightMatrix = new SimpleWeightMatrix(alphabet, weightMatrix.columns(), ModelTools.DIST_FACTORY);
            SimpleDistributionTrainerContext simpleDistributionTrainerContext = new SimpleDistributionTrainerContext();
            simpleDistributionTrainerContext.setNullModelWeight(this.nullModelWeighting);
            int n = this.sampleCounts;
            int n2 = 0;
            while (n2 < simpleWeightMatrix.columns()) {
                OrderNDistribution orderNDistribution = (OrderNDistribution)simpleWeightMatrix.getColumn(n2);
                object = finiteAlphabet.iterator();
                while (object.hasNext()) {
                    changeable = (Symbol)object.next();
                    simpleDistributionTrainerContext.registerDistribution(orderNDistribution.getDistribution((Symbol)changeable));
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < simpleWeightMatrix.columns()) {
                object = weightMatrix.getColumn(n3);
                changeable = (OrderNDistribution)simpleWeightMatrix.getColumn(n3);
                Iterator iterator = finiteAlphabet.iterator();
                while (iterator.hasNext()) {
                    Symbol symbol = (Symbol)iterator.next();
                    Distribution distribution = changeable.getDistribution(symbol);
                    int n4 = 0;
                    while (n4 < n) {
                        simpleDistributionTrainerContext.addCount(distribution, object.sampleSymbol(), 1.0);
                        ++n4;
                    }
                }
                ++n3;
            }
            simpleDistributionTrainerContext.train();
            return simpleWeightMatrix;
        }
        catch (Exception exception) {
            throw new BioError(exception, "Couldn't make second order WM.");
        }
    }

    public boolean hasNext(SLMTrainingContext sLMTrainingContext) {
        return sLMTrainingContext.getCurrentCycle() > 0 && sLMTrainingContext.getBasisList().size() >= 3;
    }
}

