/*
 * Decompiled with CFR 0.152.
 */
package fr.cea.ig.metatarget.datastructures;

import fr.cea.ig.metatarget.datastructures.ClusterPoisson;
import fr.cea.ig.metatarget.datastructures.ClusterVectorAB;
import fr.cea.ig.metatarget.datastructures.DictionaryInterface;
import fr.cea.ig.metatarget.utils.Utils;
import gnu.trove.map.hash.TIntDoubleHashMap;
import gnu.trove.map.hash.TIntLongHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;

public class Dictionary
implements DictionaryInterface {
    private static int _excludeMin = 1;
    private static int _excludeMax = 0;
    private ConcurrentMap<Long, AtomicInteger> kmerCountMap;
    private TIntLongHashMap countsHisto;
    private long minKmerCode;
    private long maxKmerCode;
    private long uniqueKmers = 0L;
    private long distinctKmers = 0L;
    private long totalKmers = 0L;
    private int maxKmerCount = 0;

    public Dictionary(int initialCapacity, int concurrencyLevel, int excludeMin, int excludeMax) {
        _excludeMin = excludeMin;
        _excludeMax = excludeMax;
        System.out.println(Utils.time() + " Using Dictionary ORIGINAL");
        this.kmerCountMap = new ConcurrentHashMap<Long, AtomicInteger>(initialCapacity, 0.75f, concurrencyLevel);
        this.minKmerCode = Long.MAX_VALUE;
        this.maxKmerCode = Long.MIN_VALUE;
    }

    public long getUniqueKmers() {
        return this.uniqueKmers;
    }

    public long getDistinctKmers() {
        return this.distinctKmers;
    }

    public long getTotalKmers() {
        return this.totalKmers;
    }

    @Override
    public void clear() {
        if (this.countsHisto != null) {
            this.countsHisto.clear();
        }
        this.countsHisto = null;
        if (this.kmerCountMap != null) {
            this.kmerCountMap.clear();
        }
        this.kmerCountMap = null;
    }

    public Map<Long, AtomicInteger> getHashMap() {
        return this.kmerCountMap;
    }

    public Set<Long> getKmerCodes() {
        return this.kmerCountMap.keySet();
    }

    @Override
    public void insert(long kmerCode) {
        if (kmerCode < 0L) {
            return;
        }
        AtomicInteger oldCount = this.kmerCountMap.putIfAbsent(kmerCode, new AtomicInteger(1));
        if (oldCount != null) {
            oldCount.incrementAndGet();
        }
    }

    @Override
    public void removeAll(int minCount) {
        for (long kmer : this.getKmerCodes()) {
            if (this.getGlobalCountFor(kmer) >= minCount) continue;
            this.kmerCountMap.remove(kmer);
        }
    }

    @Override
    public int getMaxCount() {
        if (this.maxKmerCount == 0) {
            this.createCountsHisto();
        }
        return this.maxKmerCount;
    }

    @Override
    public TIntLongHashMap getCountsHisto() {
        if (this.countsHisto == null) {
            this.createCountsHisto();
        }
        return this.countsHisto;
    }

    @Override
    public int getGlobalCountFor(long kmer) {
        AtomicInteger gc = (AtomicInteger)this.kmerCountMap.get(kmer);
        if (gc != null) {
            return gc.get();
        }
        return 0;
    }

    private TIntLongHashMap createCountsHisto() {
        StringBuilder sb = new StringBuilder();
        this.countsHisto = new TIntLongHashMap();
        this.uniqueKmers = 0L;
        this.distinctKmers = 0L;
        this.totalKmers = 0L;
        this.maxKmerCount = 0;
        for (Map.Entry entry : this.kmerCountMap.entrySet()) {
            long kmerCode;
            ++this.distinctKmers;
            int count = ((AtomicInteger)entry.getValue()).get();
            this.countsHisto.adjustOrPutValue(count, 1L, 1L);
            if (count == 1) {
                ++this.uniqueKmers;
            }
            this.totalKmers += (long)count;
            if (count > this.maxKmerCount) {
                this.maxKmerCount = count;
            }
            if ((kmerCode = ((Long)entry.getKey()).longValue()) < this.minKmerCode) {
                this.minKmerCode = kmerCode;
            }
            if (kmerCode <= this.maxKmerCode) continue;
            this.maxKmerCode = kmerCode;
        }
        sb.append("Unique:\t\t" + this.uniqueKmers + "\n");
        sb.append("Distinct:\t" + this.distinctKmers + "\n");
        sb.append("Total:\t\t" + this.totalKmers + "\n");
        sb.append("MaxCount:\t" + this.maxKmerCount + "\n");
        System.out.println(Utils.time());
        System.out.println(sb.toString());
        return this.countsHisto;
    }

    @Override
    public ClusterVectorAB[] createABClusterVectors(ClusterPoisson[] clusterPoissons, int excludeMin, int excludeMax) {
        int numberOfClusters = clusterPoissons.length;
        System.out.println(Utils.time() + " START of Creating AB Cluster Vectors");
        ClusterVectorAB[] clusterVectors = new ClusterVectorAB[numberOfClusters];
        try {
            CountDownLatch doneSignal = new CountDownLatch(numberOfClusters);
            for (int i = 0; i < numberOfClusters; ++i) {
                System.out.println("\tCluster " + (i + 1) + "\tAbundance=" + clusterPoissons[i].getGenomeAbundance() + "\tLength=" + clusterPoissons[i].getGenomeLength() + "\tLowLimit=" + clusterPoissons[i].getLowLimit() + "\tHighLimit=" + clusterPoissons[i].getHighLimit());
                Thread t = new Thread(new CreateABClusterVectorThread(i, clusterPoissons, clusterVectors, doneSignal, excludeMin, excludeMax, this));
                t.start();
            }
            doneSignal.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println(Utils.time() + " END of Creating AB Cluster Vectors");
        return clusterVectors;
    }

    private class CreateABClusterVectorThread
    implements Runnable {
        private int clusterId;
        private ClusterPoisson[] clusterPoissons;
        private ClusterVectorAB[] clusterVectors;
        private CountDownLatch doneSignal;
        private int excludeMin;
        private int excludeMax;
        private Dictionary dictionary;

        private CreateABClusterVectorThread(int clusterId, ClusterPoisson[] clusterPoissons, ClusterVectorAB[] clusterVectors, CountDownLatch doneSignal, int excludeMin, int excludeMax, Dictionary dictionary2) {
            this.clusterId = clusterId;
            this.clusterPoissons = clusterPoissons;
            this.clusterVectors = clusterVectors;
            this.doneSignal = doneSignal;
            this.excludeMin = excludeMin;
            this.excludeMax = excludeMax;
            this.dictionary = dictionary2;
        }

        @Override
        public void run() {
            ClusterVectorAB cv;
            TIntDoubleHashMap probabilities = new TIntDoubleHashMap();
            TIntLongHashMap countsHisto = Dictionary.this.getCountsHisto();
            for (int count : countsHisto.keys()) {
                probabilities.put(count, this.clusterPoissons[this.clusterId].getProbability(count, this.clusterPoissons, this.clusterId));
            }
            long expectedSize = Dictionary.this.distinctKmers;
            if (expectedSize <= 0L) {
                expectedSize = Integer.MAX_VALUE;
            }
            this.clusterVectors[this.clusterId] = cv = new ClusterVectorAB(expectedSize, (Dictionary.this.maxKmerCode + Dictionary.this.minKmerCode) / 2L);
            for (Map.Entry e : Dictionary.this.kmerCountMap.entrySet()) {
                int count;
                count = ((AtomicInteger)e.getValue()).get();
                if (count < this.excludeMin || this.excludeMax != 0 && count > this.excludeMax) continue;
                cv.insertKMer((Long)e.getKey(), probabilities.get(count));
            }
            double norm = cv.getNorm();
            System.out.println(Utils.time() + "\tCluster " + (this.clusterId + 1) + "\tsize in kmers=" + cv.size() + "\tnorm=" + norm);
            this.doneSignal.countDown();
        }
    }
}

