/*
 * Decompiled with CFR 0.152.
 */
package com.gkano.bioinfo.vcf;

import com.gkano.bioinfo.var.Logger;
import com.gkano.bioinfo.vcf.VCFDecoder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;
import org.itadaki.bzip2.BZip2InputStream;
import org.tukaani.xz.XZInputStream;

public class VCFStreamingIterator
implements Iterable<String>,
Iterator<String>,
AutoCloseable {
    private final List<String> inputPaths;
    private final VCFDecoder decoder;
    private BufferedReader currentReader;
    private int currentPathIndex;
    private String nextLine;
    private String nextDecoded;
    private boolean usingStdin = false;
    private boolean verbose = false;

    public VCFStreamingIterator(VCFDecoder decoder, boolean verbose, List<String> inputPaths) {
        this.inputPaths = inputPaths;
        this.decoder = decoder;
        this.verbose = verbose;
        this.currentPathIndex = -1;
        Logger.setVerbose(this.verbose);
        this.advanceFile();
        this.advance();
    }

    public VCFStreamingIterator(VCFDecoder decoder, boolean verbose, String ... inputPaths) {
        this(decoder, verbose, Arrays.asList(inputPaths));
    }

    private void advanceFile() {
        try {
            if (this.currentReader != null && !this.usingStdin) {
                this.currentReader.close();
            }
            ++this.currentPathIndex;
            if (this.currentPathIndex < this.inputPaths.size()) {
                InputStream in;
                String path = this.inputPaths.get(this.currentPathIndex);
                Logger.info(this, "Reading from: " + path);
                if (path.equals("-")) {
                    in = System.in;
                    this.usingStdin = true;
                } else {
                    File file = new File(path);
                    in = new FileInputStream(file);
                }
                in = this.detectAndWrap(in);
                this.currentReader = new BufferedReader(new InputStreamReader(in));
            } else {
                this.currentReader = null;
            }
        }
        catch (IOException e) {
            Logger.error(this, "Error opening input: " + this.inputPaths.get(this.currentPathIndex));
            Logger.error(this, e.getMessage());
        }
    }

    private InputStream detectAndWrap(InputStream in) throws IOException {
        int MAX_MAGIC = 6;
        PushbackInputStream pb = new PushbackInputStream(in, 6);
        byte[] signature = new byte[6];
        int read = pb.read(signature, 0, signature.length);
        if (read > 0) {
            pb.unread(signature, 0, read);
        } else if (read == -1) {
            Logger.info(this, "Empty stream; no compression detected.");
            return pb;
        }
        if (read >= 2 && signature[0] == 31 && signature[1] == -117) {
            Logger.info(this, "Detected gzip compression.");
            return new GZIPInputStream(pb);
        }
        if (read >= 3 && signature[0] == 66 && signature[1] == 90 && signature[2] == 104) {
            Logger.info(this, "Detected bzip2 compression.");
            return new BZip2InputStream((InputStream)pb, false);
        }
        if (read >= 6 && signature[0] == -3 && signature[1] == 55 && signature[2] == 122 && signature[3] == 88 && signature[4] == 90 && signature[5] == 0) {
            Logger.info(this, "Detected xz compression.");
            return new XZInputStream((InputStream)pb);
        }
        Logger.info(this, "No compression detected.");
        return pb;
    }

    private void advance() {
        try {
            while (this.currentReader != null) {
                this.nextLine = this.currentReader.readLine();
                if (this.nextLine != null) {
                    this.nextDecoded = this.decoder.decode(this.nextLine);
                    if (this.nextDecoded == null) continue;
                    return;
                }
                this.advanceFile();
            }
            this.nextDecoded = null;
        }
        catch (IOException e) {
            Logger.error(this, "Error reading input");
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextDecoded != null;
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String result = this.nextDecoded;
        this.advance();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() not supported.");
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }

    @Override
    public void close() {
        try {
            if (this.currentReader != null && !this.usingStdin) {
                this.currentReader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

