/*
 * Decompiled with CFR 0.152.
 */
package main;

import base.ArraysMerger;
import base.ArraysMergerHeap;
import base.CountObject;
import base.CountObjectIterator;
import base.DebugLog;
import base.FatalException;
import base.MarkovModelInfo;
import base.MarkovModelOption;
import base.RegexOption;
import base.SELEXConfigReader;
import base.Sequence;
import base.Util;
import config.ExperimentReference;
import config.InputDataSetStats;
import config.SELEXSequencingConfig;
import config.Sample;
import config.SequencingRunInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import main.SELEX;

public class SimpleKmerCount {
    private String path;
    private int kmerLength;
    private int variableLength;
    private long kmerMask = 0L;
    private String outputPath;
    private Boolean saveAsText = false;
    private String leftBarcode;
    private String leftFlank;
    private Boolean leftStartsWith;
    private String rightBarcode;
    private static int NUCLEOTIDE_PER_LONG = 30;
    private boolean externalSorting = false;
    private int MAX_THREAD_NUM = 1;
    private int KMER_PER_THREAD = 2000000;
    private int EXTERNAL_SORT_SIZE = 2000000;
    private int[] counts;
    private ArraysMerger merger;
    private String tempFolder = "./SELEX/";
    private long minimalCount;
    private long maximalCount;
    private long noOfValidRead;
    private Boolean isBinaryFile = false;
    private Boolean isFASTQFile = true;
    private int leftOffset = 0;
    private Boolean useSlidingWindow = true;
    private RegexOption regexOption;
    public static Boolean includeReversed = false;
    public static final String DATA_FILE_TYPE_TXT = "FASTQ.TXT";
    public static final String DATA_FILE_FASTA_TYPE_TXT = "FASTA.TXT";
    public static final String DATA_FILE_TYPE_BINARY_CACHE = "FASTQ.BINARY.CACHE";
    public static final String DATA_FILE_TYPE_BINARY_COUNT = "FASTQ.BINARY.COUNT";
    private Long fastqTotalLineCount;
    private Long fastqTotalReadCount;
    private Long fastqBarcodeMatchedReadCount;
    private Long fastqValidReadCount;
    private String fastqCacheFileName;
    private Boolean fastqFileProcessed;
    private ExperimentReference dataSet;
    private static Random randomObj = new Random();
    public final String INCOMPLETE_FLAG = "-incomplete";
    private float[] probabilities;
    private float[] probabilities2;

    public void initTraining(SELEXConfigReader sELEXConfigReader, ExperimentReference experimentReference) {
        try {
            this.leftOffset = 0;
            this.useSlidingWindow = true;
            this.dataSet = experimentReference;
            DebugLog.log("Reading configurtion of [" + SELEX.getSampleID(experimentReference) + "]");
            SequencingRunInfo sequencingRunInfo = sELEXConfigReader.getSequencingRunInfo(experimentReference);
            if (sequencingRunInfo == null) {
                throw new RuntimeException("Can't find SequencingRunInfo[" + experimentReference.getSequencingName() + "]");
            }
            Sample sample = sELEXConfigReader.getSample(experimentReference);
            if (sample == null) {
                throw new RuntimeException("Can't find Sample[" + experimentReference.getSampleName() + "]");
            }
            this.isBinaryFile = false;
            if (DATA_FILE_TYPE_BINARY_CACHE.equals(sequencingRunInfo.getDataFileType())) {
                this.isBinaryFile = true;
            }
            if (DATA_FILE_FASTA_TYPE_TXT.equals(sequencingRunInfo.getDataFileType())) {
                this.isFASTQFile = false;
            }
            this.path = sequencingRunInfo.getDataFile();
            this.variableLength = sample.getVariableRegionLength();
            this.leftBarcode = sample.getLeftBarcode();
            this.leftFlank = sample.getLeftFlank();
            this.leftStartsWith = sELEXConfigReader.getModelSettings() == null ? Boolean.valueOf(true) : Boolean.valueOf(sELEXConfigReader.getModelSettings().getBarcodeOffset() == 0);
            this.rightBarcode = sample.getRightBarcode();
            this.trimBarcodes();
            this.initKMerLength(this.kmerLength);
        }
        catch (Exception exception) {
            DebugLog.log(exception);
            throw new RuntimeException(exception);
        }
    }

    public void setTempFolder(String string) {
        this.tempFolder = string;
    }

    public Boolean getIsBinaryFile() {
        return this.isBinaryFile;
    }

    public Boolean getIsFASTQFile() {
        return this.isFASTQFile;
    }

    public RegexOption getRegexOption() {
        return this.regexOption;
    }

    public void setRegexOption(RegexOption regexOption) {
        this.regexOption = regexOption;
    }

    private void trimBarcodes() {
        this.leftBarcode = this.leftBarcode == null ? "" : this.leftBarcode.trim();
        this.rightBarcode = this.rightBarcode == null ? "" : this.rightBarcode.trim();
        DebugLog.log("left = " + this.leftBarcode);
        DebugLog.log("right = " + this.rightBarcode);
        DebugLog.log("Left Barcode Starts at the beginning = " + this.leftStartsWith);
    }

    public void initKMerLength(String string) {
        this.initKMerLength(Integer.parseInt(string));
    }

    public void initKMerLength(Integer n) {
        this.minimalCount = Long.MAX_VALUE;
        this.maximalCount = Long.MIN_VALUE;
        this.kmerLength = n;
        DebugLog.log("KMerLength:" + this.kmerLength);
        this.kmerMask = 0L;
        for (int i = 0; i < this.kmerLength; ++i) {
            this.kmerMask <<= 2;
            this.kmerMask |= 3L;
        }
        boolean bl = this.externalSorting = this.kmerLength >= 14;
        if (this.externalSorting) {
            String string = this.getFileName() + ":" + this.getFastqKey() + ":" + this.kmerLength;
            this.merger = new ArraysMerger(this.tempFolder, "temp-" + Util.getMD5(string), this.EXTERNAL_SORT_SIZE);
        } else {
            long l = 1 << this.kmerLength * 2;
            long l2 = l * 4L / 1000000L;
            try {
                DebugLog.log("Requesting memory size of " + l2 + "MB (" + l + ")elements");
                this.counts = null;
                this.counts = new int[(int)l];
                DebugLog.log("Memory allocated.");
            }
            catch (Exception exception) {
                throw new FatalException("JVM Memory is not large enough. At least " + l2 + " MB needed.");
            }
        }
    }

    private void cacheOutput(DataOutputStream dataOutputStream, SubString subString) throws IOException {
        int n = 0;
        long l = 0L;
        int n2 = subString.startIdx;
        while (n2 < subString.endIdx) {
            char c = subString.base.charAt(n2);
            long l2 = Sequence.getCharCode(c);
            l = l << 2 | l2;
            if (n == NUCLEOTIDE_PER_LONG - 1) {
                dataOutputStream.writeLong(l);
                n = -1;
                l = 0L;
            }
            ++n2;
            ++n;
        }
        if (n != 0) {
            dataOutputStream.writeLong(l << (NUCLEOTIDE_PER_LONG - n) * 2);
        }
    }

    public int getLeftOffset() {
        return this.leftOffset;
    }

    public void setLeftOffset(int n) {
        this.leftOffset = n;
    }

    public void setUseSlidingWindow(Boolean bl) {
        this.useSlidingWindow = bl;
    }

    private void cacheOutput(DataOutputStream dataOutputStream, BinarySequence binarySequence) throws IOException {
        for (int i = 0; i < binarySequence.data.length; ++i) {
            dataOutputStream.writeLong(binarySequence.data[i]);
        }
    }

    public String getCacheFileName() {
        return this.tempFolder + this.getFileName(this.path) + "-" + Util.getMD5(this.getFastqKey());
    }

    private String getFileName() {
        return this.path;
    }

    public String getFastqKey() {
        String string = this.leftBarcode + "-" + this.rightBarcode + "-" + this.variableLength + "-" + Util.getVariableRegionFilterString(this.regexOption);
        DebugLog.log("Fastqkey: " + string);
        return string;
    }

    private String getFileName(String string) {
        return new File(string).getName();
    }

    private int getRandomIdx(long[] lArray, long[] lArray2, int n) {
        int n2 = randomObj.nextInt(n);
        while (lArray[n2] >= lArray2[n2]) {
            if (--n2 >= 0) continue;
            n2 = n - 1;
        }
        return n2;
    }

    public Object[] splitCacheFile(SELEXConfigReader sELEXConfigReader, ExperimentReference experimentReference, Properties properties, String string, Long l, Double[] doubleArray, String string2, List<InputDataSetStats> list) {
        String[] stringArray = new String[]{};
        String[] stringArray2 = new String[]{};
        Integer[] integerArray = new Integer[]{};
        int[] nArray = new int[]{};
        long[] lArray = new long[]{};
        try {
            Object object;
            int n;
            String string3 = this.getCacheFileName();
            if (!new File(string3).exists()) {
                throw new RuntimeException("Can't find binary cache file to split:" + string3);
            }
            DebugLog.log("Opening cache file:" + string3);
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(string3)));
            int n2 = (int)Math.ceil((double)this.variableLength * 1.0 / (double)NUCLEOTIDE_PER_LONG);
            DebugLog.log("Length of each sequence:" + n2);
            int n3 = doubleArray.length;
            DebugLog.log("Spliting into [" + n3 + "] parts.");
            SequencingRunInfo sequencingRunInfo = sELEXConfigReader.getSequencingRunInfo(experimentReference);
            Sample sample = sELEXConfigReader.getSample(experimentReference);
            DataOutputStream[] dataOutputStreamArray = new DataOutputStream[n3];
            lArray = new long[n3];
            long[] lArray2 = new long[n3];
            stringArray = new String[n3];
            stringArray2 = new String[n3];
            integerArray = new Integer[n3];
            nArray = new int[n3];
            DebugLog.log("Total Size:" + l);
            for (n = 0; n < n3; ++n) {
                lArray[n] = 0L;
                lArray2[n] = (long)Math.ceil((double)l.longValue() * doubleArray[n]);
                DebugLog.log("Bucket Cap[" + n + "] Size:" + lArray2[n]);
                object = string2 + "/" + n + ".part";
                String string4 = string2 + "/" + n + ".xml";
                String string5 = sample.getName() + "." + string + "." + (n + 1);
                dataOutputStreamArray[n] = new DataOutputStream(new BufferedOutputStream(new FileOutputStream((String)object), 0x500000));
                DebugLog.log("Outputting to : " + (String)object);
                SELEXSequencingConfig sELEXSequencingConfig = new SELEXSequencingConfig();
                SequencingRunInfo sequencingRunInfo2 = Util.cloneWithoutSample(sequencingRunInfo);
                sequencingRunInfo2.setDataFile((String)object);
                sequencingRunInfo2.setName(sequencingRunInfo2.getName() + "." + string + "." + (n + 1));
                Sample sample2 = Util.cloneSample(sample);
                sample2.setName(string5);
                sequencingRunInfo2.getSample().add(sample2);
                sequencingRunInfo2.setDataFileType(DATA_FILE_TYPE_BINARY_CACHE);
                sELEXSequencingConfig.getSequencingRunInfo().add(sequencingRunInfo2);
                SELEXConfigReader.writeConfig(string4, sELEXSequencingConfig);
                DebugLog.log("XML Config : " + string4);
                properties.setProperty(string5, string4);
                stringArray[n] = sequencingRunInfo2.getName();
                stringArray2[n] = sample2.getName();
                integerArray[n] = sample2.getRound();
                ExperimentReference experimentReference2 = new ExperimentReference();
                experimentReference2.setSequencingName(sequencingRunInfo2.getName());
                experimentReference2.setSampleName(sample2.getName());
                experimentReference2.setSampleRound(sample2.getRound());
                InputDataSetStats inputDataSetStats = new InputDataSetStats();
                inputDataSetStats.setId(SELEX.getSampleID(experimentReference2));
                inputDataSetStats.setOriginalDataFilePath(sequencingRunInfo2.getDataFile());
                inputDataSetStats.setCachedDataFilePath(sequencingRunInfo2.getDataFileType());
                inputDataSetStats.setExperimentReference(experimentReference);
                inputDataSetStats.setLeftBarcode(sample2.getLeftBarcode());
                inputDataSetStats.setRightBarcode(sample2.getRightBarcode());
                list.add(inputDataSetStats);
            }
            n = 0;
            do {
                int n4;
                object = new BinarySequence(n2);
                for (n4 = 0; n4 < n2; ++n4) {
                    long l2 = dataInputStream.readLong();
                    ((BinarySequence)object).write(l2);
                }
                int n5 = n4 = this.getRandomIdx(lArray, lArray2, n3);
                lArray[n5] = lArray[n5] + 1L;
                this.cacheOutput(dataOutputStreamArray[n4], (BinarySequence)object);
            } while ((long)(++n) != l);
            for (int i = 0; i < n3; ++i) {
                dataOutputStreamArray[i].flush();
                DebugLog.log("Bucket[" + i + "] Size:" + lArray[i]);
                InputDataSetStats inputDataSetStats = list.get(i);
                inputDataSetStats.setTotalLineCount(lArray[i]);
                inputDataSetStats.setTotalReadCount(lArray[i]);
                inputDataSetStats.setTotalBarcodeMatchedReadCount(lArray[i]);
                inputDataSetStats.setValidReadCount(lArray[i]);
            }
        }
        catch (Exception exception) {
            DebugLog.log(exception);
            throw new RuntimeException(exception);
        }
        for (int i = 0; i < integerArray.length; ++i) {
            nArray[i] = integerArray[i];
        }
        return new Object[]{stringArray, stringArray2, nArray, lArray};
    }

    public void processCacheFile(String string) throws Exception {
        DebugLog.log("Opening cache file:" + string);
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(string)));
        ExecutorService executorService = Executors.newFixedThreadPool(this.MAX_THREAD_NUM);
        Semaphore semaphore = new Semaphore(this.MAX_THREAD_NUM + 1);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        DebugLog.log("Reading...");
        int n4 = (int)Math.ceil((double)this.variableLength * 1.0 / (double)NUCLEOTIDE_PER_LONG);
        DebugLog.log("Length of each sequence:" + n4);
        int n5 = this.variableLength - this.kmerLength + 1;
        int n6 = this.KMER_PER_THREAD / n5;
        DebugLog.log("Reading...");
        boolean bl = false;
        while (!bl) {
            Object object;
            boolean bl2 = bl = dataInputStream.available() == 0;
            if (!bl) {
                object = new BinarySequence(n4);
                for (int i = 0; i < n4; ++i) {
                    long l = dataInputStream.readLong();
                    ((BinarySequence)object).write(l);
                }
                linkedList.add(object);
                ++n;
                ++n2;
                ++n3;
            }
            if (n3 == n6 || bl) {
                object = linkedList;
                linkedList = new LinkedList();
                semaphore.acquire();
                n3 = 0;
                executorService.submit(new Runnable((List)object, executorService, semaphore){
                    final /* synthetic */ List val$linesLocal;
                    final /* synthetic */ ExecutorService val$service;
                    final /* synthetic */ Semaphore val$semaphore;
                    {
                        this.val$linesLocal = list;
                        this.val$service = executorService;
                        this.val$semaphore = semaphore;
                    }

                    @Override
                    public void run() {
                        DebugLog.log("Processsing....trunk of size:" + this.val$linesLocal.size());
                        try {
                            SimpleKmerCount.this.doProcessBinarySeqence(this.val$linesLocal, SimpleKmerCount.this.leftOffset);
                        }
                        catch (Throwable throwable) {
                            DebugLog.log(throwable);
                            this.val$service.shutdown();
                            throw new RuntimeException(throwable);
                        }
                        finally {
                            this.val$semaphore.release();
                        }
                    }
                });
            }
            if (n2 % 1000000 != 0) continue;
            DebugLog.log("Read Count:" + n2);
            Util.printMemeoryUsage();
        }
        executorService.shutdown();
        boolean bl3 = executorService.awaitTermination(1000L, TimeUnit.SECONDS);
        DebugLog.log("service.awaitTermination result:" + bl3);
        DebugLog.log("Total sequence lines:" + n);
        DebugLog.log("Valid k-mer sequences:" + n2);
        linkedList = null;
        try {
            this.save(this.saveAsText);
        }
        catch (Exception exception) {
            DebugLog.log(exception);
        }
    }

    public void setSaveAsText(Boolean bl) {
        this.saveAsText = bl;
    }

    public void process() throws Exception {
        String string;
        DebugLog.log("Input file[" + this.getFileName() + "] is binary[" + this.isBinaryFile + "] isFASTQFile[" + this.isFASTQFile + "] LeftOffset[" + this.leftOffset + "]");
        if (!this.isFASTQFile.booleanValue()) {
            this.processFASTAFile();
            return;
        }
        if (this.kmerLength > this.variableLength) {
            throw new RuntimeException("Kmer count length[" + this.kmerLength + "] is greater than variable region length[" + this.variableLength + "].");
        }
        DebugLog.log("UseSlidingWindow = " + this.useSlidingWindow);
        DebugLog.log("LeftOffSet       = " + this.leftOffset);
        DebugLog.log("IncludeReversed  = " + includeReversed);
        if (this.isBinaryFile.booleanValue()) {
            this.fastqFileProcessed = false;
            this.processCacheFile(this.getFileName());
            return;
        }
        this.fastqCacheFileName = string = this.getCacheFileName();
        this.fastqFileProcessed = true;
        if (new File(string).exists()) {
            this.fastqFileProcessed = false;
            this.processCacheFile(string);
            return;
        }
        string = string + "-incomplete";
        DebugLog.log("Cache to file:" + string);
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string), 10000000));
        BufferedReader bufferedReader = null;
        String string2 = this.getFileName();
        bufferedReader = string2.endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(string2)))) : new BufferedReader(new InputStreamReader(new FileInputStream(string2)));
        int n = this.variableLength - this.kmerLength + 1;
        int n2 = this.KMER_PER_THREAD / n;
        final ExecutorService executorService = Executors.newFixedThreadPool(this.MAX_THREAD_NUM);
        final Semaphore semaphore = new Semaphore(this.MAX_THREAD_NUM * 2);
        long l = 0L;
        long l2 = 0L;
        String string3 = null;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        LinkedList<SubString> linkedList = new LinkedList<SubString>();
        Pattern pattern = null;
        Pattern pattern2 = null;
        Pattern pattern3 = null;
        if (this.regexOption != null) {
            pattern = this.regexOption.getVariableRegionExcludePattern();
            pattern2 = this.regexOption.getVariableRegionIncludePattern();
            pattern3 = this.regexOption.getVariableRegionGroupPattern();
        }
        DebugLog.log("Reading...");
        boolean bl = false;
        while (!bl) {
            string3 = bufferedReader.readLine();
            boolean bl2 = bl = string3 == null;
            if (!bl) {
                if (++l % 4L != 2L) continue;
                boolean bl3 = true;
                ++l2;
                int n3 = -1;
                if (this.leftStartsWith.booleanValue()) {
                    if (string3.startsWith(this.leftBarcode)) {
                        n3 = 0;
                    }
                } else {
                    n3 = string3.indexOf(this.leftBarcode);
                }
                int n4 = n3 + this.leftBarcode.length() + this.variableLength;
                if (n3 != -1 && string3.regionMatches(n4, this.rightBarcode, 0, this.rightBarcode.length())) {
                    int n5;
                    ++l5;
                    for (int i = n5 = n3 + this.leftBarcode.length(); i < n4; ++i) {
                        if (Sequence.isValidSymbol(string3.charAt(i))) continue;
                        bl3 = false;
                        break;
                    }
                    if (bl3) {
                        String string4 = null;
                        if (pattern3 != null) {
                            string4 = string3.substring(n5, n4);
                            bl3 = false;
                            Matcher matcher = pattern3.matcher(string4);
                            if (matcher.find() && matcher.groupCount() > 0) {
                                n4 = n5 + matcher.end(1);
                                n5 += matcher.start(1);
                                bl3 = true;
                            }
                        } else if (pattern2 != null) {
                            string4 = string3.substring(n5, n4);
                            if (!pattern2.matcher(string4).find()) {
                                bl3 = false;
                            }
                        } else if (pattern != null && pattern.matcher(string4 = string3.substring(n5, n4)).find()) {
                            bl3 = false;
                        }
                        if (!bl3) {
                            ++l6;
                        }
                    }
                    if (bl3) {
                        ++l3;
                        ++l4;
                        SubString subString = new SubString(string3, n5, n4);
                        linkedList.add(subString);
                        this.cacheOutput(dataOutputStream, subString);
                    }
                }
            }
            if (l4 != (long)n2 && !bl) continue;
            DebugLog.log("Read Count:" + l3);
            Util.printMemeoryUsage();
            final LinkedList<SubString> linkedList2 = linkedList;
            linkedList = new LinkedList();
            semaphore.acquire();
            l4 = 0L;
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    DebugLog.log("Processsing....trunk of size:" + linkedList2.size());
                    try {
                        SimpleKmerCount.this.doProcess(linkedList2, SimpleKmerCount.this.leftOffset);
                    }
                    catch (Throwable throwable) {
                        DebugLog.log(throwable);
                        executorService.shutdown();
                        throw new RuntimeException(throwable);
                    }
                    finally {
                        semaphore.release();
                    }
                }
            });
        }
        executorService.shutdown();
        boolean bl4 = executorService.awaitTermination(1000L, TimeUnit.SECONDS);
        DebugLog.log("service.awaitTermination result:" + bl4);
        while (!executorService.isTerminated()) {
            DebugLog.log("waiting...");
            Thread.sleep(1000L);
        }
        linkedList = null;
        DebugLog.log("Total lines:" + l);
        DebugLog.log("Total sequence lines:" + l2);
        DebugLog.log("Total barcode-matched lines:" + l5);
        DebugLog.log("Total filtered lines:" + l6);
        DebugLog.log("Valid k-mer sequences:" + l3);
        this.fastqTotalLineCount = l;
        this.fastqTotalReadCount = l2;
        this.fastqBarcodeMatchedReadCount = l5;
        this.fastqValidReadCount = l3;
        try {
            dataOutputStream.close();
            String string5 = string.substring(0, string.length() - "-incomplete".length());
            DebugLog.log("Rename cache file [" + string + "] to [" + string5 + "].");
            new File(string).renameTo(new File(string5));
            this.save(this.saveAsText);
        }
        catch (Exception exception) {
            DebugLog.log(exception);
        }
    }

    public void processFASTAFile() throws Exception {
        DebugLog.log("IncludeReversed  = " + includeReversed);
        this.fastqFileProcessed = true;
        BufferedReader bufferedReader = null;
        String string = this.getFileName();
        bufferedReader = string.endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(string)))) : new BufferedReader(new InputStreamReader(new FileInputStream(string)));
        long l = 0L;
        long l2 = 0L;
        int n = -1;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        LinkedList linkedList = new LinkedList();
        DebugLog.log("Reading...");
        DebugLog.log("Header Info:\t" + bufferedReader.readLine());
        long l7 = 0L;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        boolean bl = false;
        Sequence sequence = null;
        StringBuffer stringBuffer = new StringBuffer();
        while (!bl) {
            n = bufferedReader.read();
            bl = n == -1;
            char c = (char)n;
            if (!Sequence.isValidSymbolEnhanced(c)) {
                ++l7;
                hashSet.add(Integer.valueOf(c));
            } else {
                if (sequence == null) {
                    stringBuffer.append(c);
                    if (stringBuffer.length() != this.kmerLength) continue;
                    sequence = new Sequence(stringBuffer.toString(), 0, this.kmerLength);
                } else {
                    long l8 = sequence.getValue();
                    long l9 = Sequence.getCharCode(c);
                    long l10 = (l8 << 2 | l9) & this.kmerMask;
                    sequence = new Sequence(l10, this.kmerLength);
                }
                if (this.regexOption != null) {
                    boolean bl2 = true;
                    if (this.regexOption.getKmerIncludePattern() != null) {
                        bl2 = this.regexOption.getKmerIncludePattern().matcher(sequence.getString()).find();
                    }
                    if (this.regexOption.getKmerExcludePattern() != null) {
                        boolean bl3 = bl2 = !this.regexOption.getKmerExcludePattern().matcher(sequence.getString()).find();
                    }
                    if (this.regexOption.getKmerIncludeOnlyPattern() != null) {
                        bl2 = this.regexOption.getKmerIncludeOnlyPattern().matcher(sequence.getString()).find();
                    }
                    if (!bl2) continue;
                }
                ++l3;
                if (this.externalSorting) {
                    this.merger.add(new CountObject(sequence, 1));
                    if (includeReversed.booleanValue()) {
                        ++l3;
                        this.merger.add(new CountObject(sequence.getReverseComplement(), 1));
                    }
                } else {
                    this.updateCounts(sequence, 1);
                    if (includeReversed.booleanValue()) {
                        ++l3;
                        this.updateCounts(sequence.getReverseComplement(), 1);
                    }
                }
            }
            if (bl) continue;
            ++l;
        }
        DebugLog.log("Total charCounts: " + l);
        DebugLog.log("numInvalidChar: " + l7);
        DebugLog.log("invalidSymbols: " + hashSet);
        DebugLog.log("Valid k-mer sequences:" + l3);
        this.fastqTotalLineCount = 2L;
        this.fastqTotalReadCount = 2L;
        this.fastqBarcodeMatchedReadCount = 2L;
        this.fastqValidReadCount = l3;
        this.fastqCacheFileName = "NA";
        try {
            this.save(this.saveAsText);
        }
        catch (Exception exception) {
            DebugLog.log(exception);
        }
    }

    private void doProcess(List<SubString> list, int n) {
        DebugLog.log("doProcessing:" + list.size());
        int n2 = 0;
        for (SubString subString : list) {
            ++n2;
            try {
                if (this.externalSorting) {
                    for (Sequence sequence : this.slidingWindow(subString.base, subString.startIdx, subString.endIdx, n, this.useSlidingWindow)) {
                        this.merger.add(new CountObject(sequence, 1));
                        if (!includeReversed.booleanValue()) continue;
                        this.merger.add(new CountObject(sequence.getReverseComplement(), 1));
                    }
                    continue;
                }
                for (Sequence sequence : this.slidingWindow(subString.base, subString.startIdx, subString.endIdx, n, this.useSlidingWindow)) {
                    this.updateCounts(sequence, 1);
                    if (!includeReversed.booleanValue()) continue;
                    this.updateCounts(sequence.getReverseComplement(), 1);
                }
            }
            catch (FatalException fatalException) {
                DebugLog.log(fatalException);
                throw fatalException;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                DebugLog.log(outOfMemoryError);
                throw outOfMemoryError;
            }
            catch (Throwable throwable) {
                System.err.println("Error processing:" + subString);
                DebugLog.log(throwable);
            }
        }
    }

    private void doProcessBinarySeqence(List<BinarySequence> list, int n) {
        int n2 = list.size();
        int n3 = 0;
        for (BinarySequence binarySequence : list) {
            ++n3;
            try {
                if (this.externalSorting) {
                    for (Sequence sequence : this.slidingWindowBinary(binarySequence, n, this.useSlidingWindow)) {
                        this.merger.add(new CountObject(sequence, 1));
                        if (!includeReversed.booleanValue()) continue;
                        this.merger.add(new CountObject(sequence.getReverseComplement(), 1));
                    }
                    continue;
                }
                for (Sequence sequence : this.slidingWindowBinary(binarySequence, n, this.useSlidingWindow)) {
                    this.updateCounts(sequence, 1);
                    if (!includeReversed.booleanValue()) continue;
                    this.updateCounts(sequence.getReverseComplement(), 1);
                }
            }
            catch (FatalException fatalException) {
                DebugLog.log(fatalException);
                throw fatalException;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                DebugLog.log(outOfMemoryError);
                throw outOfMemoryError;
            }
            catch (Throwable throwable) {
                System.err.println("Error processing:" + binarySequence);
                DebugLog.log(throwable);
            }
        }
    }

    public List<Sequence> slidingWindowBinary(BinarySequence binarySequence, int n, boolean bl) {
        int n2 = this.variableLength;
        int n3 = this.kmerLength;
        int n4 = 1;
        if (bl) {
            n4 = n2 - n3 + 1 - n;
        }
        if (n4 <= 0) {
            throw new RuntimeException("Raw input [" + binarySequence + "](length:" + n2 + ") not long enough for required " + n3 + "-mer counting.");
        }
        LinkedList<Sequence> linkedList = new LinkedList<Sequence>();
        StringBuffer stringBuffer = new StringBuffer(n3);
        for (int i = 0; i < n4; ++i) {
            long l;
            long l2 = 0L;
            if (i == 0) {
                int n5;
                l = 0L;
                for (n5 = 0; n5 < n; ++n5) {
                    binarySequence.readChar();
                }
                for (n5 = 0; n5 < n3; ++n5) {
                    l = l << 2 | binarySequence.readChar();
                }
                linkedList.add(new Sequence(l, n3));
            } else {
                l = linkedList.peekLast().getValue();
                l2 = binarySequence.readChar();
                long l3 = (l << 2 | l2) & this.kmerMask;
                linkedList.add(new Sequence(l3, n3));
            }
            if (this.regexOption == null) continue;
            if (i == 0) {
                stringBuffer.append(linkedList.peekLast());
            } else {
                for (int j = stringBuffer.length() - 1; j > 0; --j) {
                    stringBuffer.setCharAt(j, stringBuffer.charAt(j - 1));
                }
                stringBuffer.setCharAt(0, Sequence.getChar((int)l2));
            }
            boolean bl2 = true;
            if (this.regexOption.getKmerIncludePattern() != null) {
                bl2 = this.regexOption.getKmerIncludePattern().matcher(stringBuffer).find();
            }
            if (this.regexOption.getKmerExcludePattern() != null) {
                boolean bl3 = bl2 = !this.regexOption.getKmerExcludePattern().matcher(stringBuffer).find();
            }
            if (this.regexOption.getKmerIncludeOnlyPattern() != null) {
                bl2 = this.regexOption.getKmerIncludeOnlyPattern().matcher(stringBuffer).find();
            }
            if (bl2) continue;
            linkedList.pollLast();
        }
        return linkedList;
    }

    public List<Sequence> slidingWindow(String string, int n, int n2, int n3, boolean bl) {
        int n4 = n2 - n;
        int n5 = this.kmerLength;
        int n6 = n4 - n5 + 1 - n3;
        if (n6 <= 0) {
            String string2 = string.substring(n, n2);
            throw new FatalException("Raw input [" + string2 + "](length:" + n4 + ") not long enough for required " + n5 + "-mer counting. Offset=[" + n3 + "] UseSlidingWindow=[" + bl + "]");
        }
        if (!bl) {
            n6 = 1;
        }
        StringBuffer stringBuffer = new StringBuffer();
        LinkedList<Sequence> linkedList = new LinkedList<Sequence>();
        long l = 0L;
        for (int i = 0; i < n6; ++i) {
            if (i == 0) {
                linkedList.add(new Sequence(string, n + i + n3, n5));
            } else {
                long l2 = linkedList.peekLast().getValue();
                l = Sequence.getCharCode(string.charAt(n + i + n5 - 1 + n3));
                long l3 = (l2 << 2 | l) & this.kmerMask;
                linkedList.add(new Sequence(l3, n5));
            }
            if (this.regexOption == null) continue;
            if (i == 0) {
                stringBuffer.append(linkedList.peekLast());
            } else {
                for (int j = stringBuffer.length() - 1; j > 0; --j) {
                    stringBuffer.setCharAt(j, stringBuffer.charAt(j - 1));
                }
                stringBuffer.setCharAt(0, Sequence.getChar((int)l));
            }
            boolean bl2 = true;
            if (this.regexOption.getKmerIncludePattern() != null) {
                bl2 = this.regexOption.getKmerIncludePattern().matcher(stringBuffer).find();
            }
            if (this.regexOption.getKmerExcludePattern() != null) {
                boolean bl3 = bl2 = !this.regexOption.getKmerExcludePattern().matcher(stringBuffer).find();
            }
            if (this.regexOption.getKmerIncludeOnlyPattern() != null) {
                bl2 = this.regexOption.getKmerIncludeOnlyPattern().matcher(stringBuffer).find();
            }
            if (bl2) continue;
            linkedList.pollLast();
        }
        return linkedList;
    }

    public String setOutputPath(String string) {
        this.outputPath = string;
        if (this.getRegexOption() != null) {
            this.outputPath = this.outputPath + "_" + Util.getMD5(this.getRegexOption().getVariableRegionRegexFormattedString());
        }
        return this.outputPath;
    }

    public void save(boolean bl) throws Exception {
        this.noOfValidRead = 0L;
        if (this.externalSorting) {
            this.merger.finish();
            Properties properties = this.merger.output(bl, this.outputPath);
            DebugLog.log(properties);
            this.noOfValidRead = (Long)properties.get("noOfValidRead");
            this.minimalCount = (Long)properties.get("lowestCount");
            this.maximalCount = (Long)properties.get("highestCount");
        } else {
            CountObject countObject;
            DebugLog.log("Outputting to file:" + this.outputPath + " [textOutput:" + bl + "]");
            PrintWriter printWriter = null;
            DataOutputStream dataOutputStream = null;
            if (bl) {
                printWriter = new PrintWriter(this.outputPath);
            } else {
                dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.outputPath), 10000000));
            }
            int n = 0;
            CountObjectIterator countObjectIterator = new CountObjectIterator(this.counts, this.kmerLength);
            while (countObjectIterator.hasNext() && (countObject = countObjectIterator.next()) != null) {
                if (bl) {
                    printWriter.println(countObject.getKey() + " " + countObject.getCount());
                } else {
                    CountObject.steamOutSequence(dataOutputStream, countObject);
                }
                this.noOfValidRead += (long)countObject.getCount().intValue();
                if (this.minimalCount > (long)countObject.getCount().intValue()) {
                    this.minimalCount = countObject.getCount().intValue();
                }
                if (this.maximalCount < (long)countObject.getCount().intValue()) {
                    this.maximalCount = countObject.getCount().intValue();
                }
                ++n;
            }
            if (bl) {
                printWriter.close();
            } else {
                CountObject.steamOutSequenceClose(dataOutputStream);
                dataOutputStream.flush();
            }
            DebugLog.log("Number of Unique read:" + n);
            DebugLog.log("Closed file:" + this.outputPath);
        }
        Util.printMemeoryUsage();
    }

    private double getPredictedCountEfficient(int n, Sequence sequence) {
        int n2 = n - this.kmerLength + 1;
        Long l = (long)(1 << this.kmerLength * 2) - 1L;
        int n3 = n - this.kmerLength;
        l = l << n3 * 2;
        long l2 = sequence.getValue();
        long l3 = (l2 & l) >> (n3 + 1) * 2;
        double d = this.probabilities2[(int)l3];
        for (int i = 0; i < n2; ++i) {
            long l4 = (l2 & l) >> (n3 - i) * 2;
            d *= (double)this.probabilities[(int)l4];
            l = l >> 2;
        }
        return d;
    }

    public static double getPredictedCountWithLeftFlank(String string, int n, Sequence sequence, float[] fArray) {
        int n2 = sequence.getLength();
        int n3 = n2 - n + 1;
        long l = (long)(1 << n * 2) - 1L;
        int n4 = n2 - n;
        l <<= n4 * 2;
        long l2 = sequence.getValue();
        int n5 = n - 1;
        double d = 1.0;
        if (n != 1) {
            int n6;
            if (string.length() < n5) {
                throw new RuntimeException("Left flank[" + string + "] is too short for calculating Markov model expected counts.");
            }
            long l3 = new Sequence(string, string.length() - n5, n5).getValue();
            long l4 = 3L << n2 * 2 - 2;
            long l5 = (1 << 2 * n5 + 2) - 1;
            long l6 = l3;
            for (n6 = 0; n6 <= n5; ++n6) {
                l6 <<= 2;
                l6 &= l5;
                d *= (double)fArray[(int)(l6 |= (l4 & l2) >> (n2 - 1 - n6) * 2)];
                l4 >>= 2;
            }
            for (n6 = 1; n6 < n3; ++n6) {
                l6 = (l2 & (l >>= 2)) >> (n4 - n6) * 2;
                d *= (double)fArray[(int)l6];
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                long l7 = (l2 & l) >> (n4 - i) * 2;
                d *= (double)fArray[(int)l7];
                l >>= 2;
            }
        }
        return d;
    }

    public static double getPredictedCount(int n, long l, Sequence sequence, int[] nArray, float[] fArray) {
        int n2 = sequence.getLength();
        if (n2 < n) {
            throw new RuntimeException("The sequence[" + sequence.getString() + "] is too short for the " + (n - 1) + "-order Markov model).");
        }
        int n3 = n2 - n + 1;
        Long l2 = (long)(1 << n * 2) - 1L;
        int n4 = n2 - n;
        l2 = l2 << n4 * 2;
        long l3 = sequence.getValue();
        double d = 1.0;
        if (n != 1) {
            long l4 = (l3 & l2) >> n4 * 2;
            d = 1.0 * (double)nArray[(int)l4] / (double)l;
            for (int i = 1; i < n3; ++i) {
                l2 = l2 >> 2;
                long l5 = (l3 & l2) >> (n4 - i) * 2;
                d *= (double)fArray[(int)l5];
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                long l6 = (l3 & l2) >> (n4 - i) * 2;
                d *= (double)fArray[(int)l6];
                l2 = l2 >> 2;
            }
        }
        return d;
    }

    public double calculateInformationGain(MarkovModelInfo markovModelInfo) throws Exception {
        Object object;
        int n = markovModelInfo.getMarkovLength();
        long l = markovModelInfo.getMarkovLengthTotalCount();
        String string = markovModelInfo.getMarkovCountsPath();
        String string2 = markovModelInfo.getMarkovObjPath();
        boolean bl = markovModelInfo.getMarkovModelMethod().toUpperCase().contains("WITH_LEFT_FLANK");
        DebugLog.log("Reading Markov Prob file:" + string2);
        FileInputStream fileInputStream = new FileInputStream(string2);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        float[] fArray = (float[])objectInputStream.readObject();
        int[] nArray = null;
        DebugLog.log("Reading Markov Count file:" + string);
        ArraysMergerHeap.MinHeapNode minHeapNode = new ArraysMergerHeap.MinHeapNode(string);
        CountObject countObject = null;
        nArray = new int[1 << 2 * n];
        while ((countObject = minHeapNode.peek()) != null) {
            object = countObject.getKey();
            nArray[(int)((Sequence)object).getValue()] = countObject.getCount();
            minHeapNode.pop();
        }
        object = this.tempFolder + "/infoGain-model-M" + n + "-L" + this.kmerLength + ".txt";
        PrintWriter printWriter = new PrintWriter((String)object);
        printWriter.println("Seqence\tExpectedProb\tExpectedCount\tObservedProb\tObservedCount");
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        boolean bl2 = true;
        CountObjectIterator countObjectIterator = null;
        countObjectIterator = this.externalSorting ? new CountObjectIterator(this.outputPath) : new CountObjectIterator(this.counts, this.kmerLength);
        while (countObjectIterator.hasNext()) {
            CountObject countObject2 = countObjectIterator.next();
            Sequence sequence = countObject2.getKey();
            double d4 = 1.0;
            d4 = bl ? SimpleKmerCount.getPredictedCountWithLeftFlank(this.leftFlank, n, sequence, fArray) : SimpleKmerCount.getPredictedCount(n, l, sequence, nArray, fArray);
            double d5 = d4 * (double)this.noOfValidRead;
            int n3 = countObject2.getCount();
            double d6 = 1.0 * (double)n3 / (double)this.noOfValidRead;
            if (n3 >= 100) {
                d += d6 * Util.log2(d6 / d4);
                d2 += d4;
                d3 += d6;
                printWriter.println(sequence.getString() + "\t" + d4 + "\t" + d5 + "\t" + d6 + "\t" + n3);
            } else {
                bl2 = false;
            }
            ++n2;
        }
        printWriter.close();
        DebugLog.log("noOfValidRead = " + this.noOfValidRead);
        d2 = Math.min(d2, 1.0);
        d3 = Math.min(d3, 1.0);
        double d7 = d;
        if (!bl2) {
            d7 += (1.0 - d3) * Util.log2((1.0 - d3) / (1.0 - d2));
        }
        DebugLog.log("Predition Length = " + this.kmerLength);
        DebugLog.log("cover100percent = " + bl2);
        DebugLog.log("S100_SUM = " + d);
        DebugLog.log("S100_MODEL_PROB_SUM = " + d2);
        DebugLog.log("S100_EXP_PROB_SUM = " + d3);
        DebugLog.log("INFO_GAIN = " + d7);
        return d7;
    }

    public double crossValidatePR(String string, long l, boolean bl) throws Exception {
        double d;
        if (this.externalSorting) {
            throw new RuntimeException("Not supported yet.");
        }
        int n = this.kmerLength;
        ArraysMergerHeap.MinHeapNode minHeapNode = new ArraysMergerHeap.MinHeapNode(string);
        CountObject countObject = null;
        boolean bl2 = false;
        PrintWriter printWriter = null;
        if (bl2) {
            String string2 = this.tempFolder + "/markovModel-" + n + ".txt";
            DebugLog.log("Outputinig stats to " + string2);
            printWriter = new PrintWriter(string2);
            printWriter.println("sequence\tobserved\tpredicted\tprob");
        }
        long l2 = 0L;
        double d2 = 0.0;
        double d3 = 0.0;
        while ((countObject = minHeapNode.peek()) != null) {
            Sequence sequence = countObject.getKey();
            ++l2;
            d2 += (double)countObject.getCount().intValue();
            double d4 = 1.0;
            d4 = bl ? SimpleKmerCount.getPredictedCountWithLeftFlank(this.leftFlank, this.kmerLength, sequence, this.probabilities) : SimpleKmerCount.getPredictedCount(this.kmerLength, this.noOfValidRead, sequence, this.counts, this.probabilities);
            long l3 = (long)(d4 * (double)l);
            d3 += (double)l3;
            if (bl2) {
                printWriter.println(sequence.getString() + "\t" + countObject.getCount() + "\t" + d4 * (double)l + "\t" + d4);
            }
            minHeapNode.pop();
        }
        if (bl2) {
            printWriter.close();
        }
        double d5 = d2 / (double)l2;
        double d6 = d3 / (double)l2;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        minHeapNode.reset();
        while ((countObject = minHeapNode.peek()) != null) {
            d = 1.0;
            d = bl ? SimpleKmerCount.getPredictedCountWithLeftFlank(this.leftFlank, this.kmerLength, countObject.getKey(), this.probabilities) : SimpleKmerCount.getPredictedCount(this.kmerLength, this.noOfValidRead, countObject.getKey(), this.counts, this.probabilities);
            long l4 = (long)(d * (double)l);
            d7 += ((double)l4 - d6) * ((double)countObject.getCount().intValue() - d5);
            d8 += Math.pow((double)l4 - d6, 2.0);
            d9 += Math.pow((double)countObject.getCount().intValue() - d5, 2.0);
            minHeapNode.pop();
        }
        DebugLog.log("Model Length : " + this.kmerLength);
        DebugLog.log("N : " + l2);
        DebugLog.log("YObservedAvg  : " + d5);
        DebugLog.log("YPredictedAvg : " + d6);
        DebugLog.log("SQUARE_X: " + d8);
        DebugLog.log("SQUARE_Y: " + d9);
        d = d7 / (Math.sqrt(d8) * Math.sqrt(d9));
        DebugLog.log("R: " + d);
        return d;
    }

    public Properties getStats() {
        Properties properties = new Properties();
        properties.put("lowestCount", (Object)this.minimalCount);
        properties.put("highestCount", (Object)this.maximalCount);
        properties.put("noOfValidRead", (Object)this.noOfValidRead);
        properties.put("fastqFileProcessed", this.fastqFileProcessed);
        if (this.fastqFileProcessed.booleanValue()) {
            properties.put("fastqTotalLineCount", this.fastqTotalLineCount);
            properties.put("fastqTotalReadCount", this.fastqTotalReadCount);
            properties.put("fastqBarcodeMatchedReadCount", this.fastqBarcodeMatchedReadCount);
            properties.put("fastqValidReadCount", this.fastqValidReadCount);
            properties.put("fastqCacheFileName", this.fastqCacheFileName);
        }
        return properties;
    }

    public void buildMarkovModelEfficient(MarkovModelOption markovModelOption) {
        if (this.externalSorting) {
            System.err.println("buildMarkovModel not suppported for 16+ mer");
        } else {
            int n;
            int n2 = -1;
            this.outputPath = this.outputPath + ".prob";
            markovModelOption.setModelLogFile(this.outputPath);
            markovModelOption.setModelOutputFile(this.outputPath + ".obj");
            DebugLog.log("Outputting to file:" + this.outputPath);
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter(this.outputPath);
            }
            catch (FileNotFoundException fileNotFoundException) {
                DebugLog.log(fileNotFoundException);
            }
            this.probabilities = new float[this.counts.length];
            this.probabilities2 = new float[this.counts.length / 4];
            Long l = (1L << 2 * this.kmerLength - 2) - 1L << 2;
            DebugLog.log("prefixMask:" + l);
            int n3 = 0;
            long l2 = 0L;
            for (n = 0; n < this.counts.length; ++n) {
                n3 += this.counts[n];
                if (n % 4 != 3) continue;
                for (int i = 0; i < 4; ++i) {
                    int n4 = n - 3 + i;
                    this.probabilities[n4] = (float)this.counts[n4] * 1.0f / (float)n3;
                    printWriter.println(new Sequence(n4, this.kmerLength).getString() + " c=" + this.counts[n4] + " s=" + n3 + " p=" + this.probabilities[n4]);
                }
                l2 += (long)n3;
                this.probabilities2[n >> 2] = n3;
                n3 = 0;
            }
            DebugLog.log("Total " + this.kmerLength + "-mer length Unique read:" + l2);
            n = 0;
            while (n < this.probabilities2.length) {
                int n5 = n++;
                this.probabilities2[n5] = this.probabilities2[n5] / (float)l2;
            }
            DebugLog.log("Mininal Count:" + n2);
            printWriter.close();
            DebugLog.log("Closed file:" + this.outputPath);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(markovModelOption.getModelOutputFile());
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(this.probabilities);
                objectOutputStream.writeObject(this.probabilities2);
                objectOutputStream.flush();
                objectOutputStream.close();
            }
            catch (Exception exception) {
                DebugLog.log(exception);
            }
        }
    }

    public void buildMarkovModelDivisionMethod(String string, long l, MarkovModelOption markovModelOption) {
        if (this.externalSorting) {
            System.err.println("buildMarkovModel not suppported for 16+ mer");
        } else {
            Object object;
            Object object2;
            int[] nArray = null;
            if (string != null) {
                DebugLog.log("Reading subKmerCount file:" + string);
                object2 = new ArraysMergerHeap.MinHeapNode(string);
                object = null;
                nArray = new int[1 << 2 * (this.kmerLength - 1)];
                while ((object = ((ArraysMergerHeap.MinHeapNode)object2).peek()) != null) {
                    Sequence sequence = ((CountObject)object).getKey();
                    nArray[(int)sequence.getValue()] = ((CountObject)object).getCount();
                    ((ArraysMergerHeap.MinHeapNode)object2).pop();
                }
            }
            this.probabilities = null;
            this.probabilities = new float[this.counts.length];
            object2 = this.outputPath + ".prob";
            markovModelOption.setModelLogFile((String)object2);
            markovModelOption.setModelOutputFile((String)object2 + ".obj2");
            DebugLog.log("Outputting to file:" + (String)object2);
            object = null;
            try {
                object = new PrintWriter((String)object2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                DebugLog.log(fileNotFoundException);
                throw new RuntimeException(fileNotFoundException);
            }
            long l2 = (1 << 2 * (this.kmerLength - 1)) - 1 << 2;
            for (int i = 0; i < this.counts.length; ++i) {
                long l3 = 0L;
                if (nArray != null) {
                    long l4 = (l2 & (long)i) >> 2;
                    this.probabilities[i] = 1.0f * (float)this.counts[i] / (float)this.noOfValidRead / (1.0f * (float)nArray[(int)l4] / (float)l);
                    l3 = nArray[(int)l4];
                } else {
                    this.probabilities[i] = 1.0f * (float)this.counts[i] / (float)this.noOfValidRead;
                    l3 = this.noOfValidRead;
                }
                ((PrintWriter)object).println(new Sequence(i, this.kmerLength).getString() + " c=" + this.counts[i] + " s= " + l3 + " p=" + this.probabilities[i]);
            }
            ((PrintWriter)object).close();
            DebugLog.log("Closed file:" + this.outputPath);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(markovModelOption.getModelOutputFile());
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(this.probabilities);
                objectOutputStream.flush();
                objectOutputStream.close();
            }
            catch (Exception exception) {
                DebugLog.log(exception);
            }
        }
    }

    private void updateCounts(Sequence sequence, int n) {
        int n2 = (int)sequence.getValue();
        this.counts[n2] = this.counts[n2] + n;
    }

    class BinarySequence {
        long[] data;
        int writeIndex = 0;
        int readIndex = 0;
        long readMask = 0L;
        int shiftOffset = 0;

        public BinarySequence(int n) {
            this.data = new long[n];
            this.writeIndex = 0;
            this.resetMask();
        }

        public void write(long l) {
            this.data[this.writeIndex++] = l;
        }

        private void resetMask() {
            this.shiftOffset = (NUCLEOTIDE_PER_LONG - 1) * 2;
            this.readMask = 3L << this.shiftOffset;
        }

        private void next() {
            this.shiftOffset -= 2;
            this.readMask >>= 2;
            if (this.shiftOffset < 0) {
                this.resetMask();
                ++this.readIndex;
            }
        }

        public long readChar() {
            long l = (this.data[this.readIndex] & this.readMask) >> this.shiftOffset;
            this.next();
            return l;
        }
    }

    class SubString {
        String base;
        int startIdx;
        int endIdx;

        public SubString(String string, int n, int n2) {
            this.base = string;
            this.startIdx = n;
            this.endIdx = n2;
        }
    }
}

