/*
 * Decompiled with CFR 0.152.
 */
package main;

import base.DebugLog;
import base.Sequence;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.util.Properties;
import java.util.zip.GZIPInputStream;

public class FastQFileScanner {
    public Object[] calculatePSFM(String string, Properties properties) throws Exception {
        return this.calculatePSFM(string, 0, null, null, properties);
    }

    public Object[] calculatePSFM(String string, int n, String string2, String string3, Properties properties) throws Exception {
        int n2;
        int n3;
        boolean bl = true;
        boolean bl2 = string2 != null && string3 != null;
        DebugLog.log("calculatePSFM() : checkBarcode = " + bl2);
        if (bl2) {
            DebugLog.log("leftBarcode    = " + string2);
            DebugLog.log("rightBarcode   = " + string3);
            DebugLog.log("variableLength = " + n);
        }
        long[][] lArray = null;
        int n4 = 0;
        BufferedReader bufferedReader = null;
        bufferedReader = string.endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(string)))) : new BufferedReader(new InputStreamReader(new FileInputStream(string)));
        long l = 0L;
        long l2 = 0L;
        String string4 = null;
        long l3 = 0L;
        DebugLog.log("Reading...");
        while ((string4 = bufferedReader.readLine()) != null) {
            char c;
            int n5;
            if (++l % 4L != 2L) continue;
            boolean bl3 = true;
            ++l2;
            n3 = string4.length();
            if (bl2) {
                n5 = -1;
                if (bl) {
                    if (string4.startsWith(string2)) {
                        n5 = 0;
                    }
                } else {
                    n5 = string4.indexOf(string2);
                }
                c = n5 + string2.length() + n;
                if (n5 == -1 || !string4.regionMatches(c, string3, 0, string3.length())) continue;
            }
            for (n5 = 0; n5 < n3; ++n5) {
                if (Sequence.isValidSymbol(string4.charAt(n5))) continue;
                bl3 = false;
                break;
            }
            if (l2 % 2000000L == 0L) {
                DebugLog.log("Processed reads:" + l2);
            }
            if (!bl3) continue;
            ++l3;
            if (lArray == null) {
                n4 = string4.length();
                lArray = new long[4][n4];
            }
            n5 = 0;
            while (n5 < n4) {
                c = string4.charAt(n5);
                n2 = (int)Sequence.getCharCode(c);
                long[] lArray2 = lArray[n2];
                int n6 = n5++;
                lArray2[n6] = lArray2[n6] + 1L;
            }
        }
        DebugLog.log("Processed reads:" + l2);
        double[][] dArray = new double[4][n4];
        for (n3 = 0; n3 < n4; ++n3) {
            long l4 = 0L;
            for (n2 = 0; n2 < 4; ++n2) {
                l4 += lArray[n2][n3];
            }
            for (n2 = 0; n2 < 4; ++n2) {
                dArray[n2][n3] = (double)lArray[n2][n3] * 1.0 / (double)l4;
            }
        }
        Object[] objectArray = new Object[4];
        for (int i = 0; i < 4; ++i) {
            objectArray[i] = dArray[i];
        }
        properties.put("fastqTotalLine", (Object)l);
        properties.put("fastqTotalRead", (Object)l2);
        properties.put("fastqValidRead", (Object)l3);
        DebugLog.log(properties);
        return objectArray;
    }

    public static void main(String[] stringArray) throws Exception {
        Properties properties = new Properties();
        FastQFileScanner fastQFileScanner = new FastQFileScanner();
        Object[] objectArray = fastQFileScanner.calculatePSFM("./sample_data/exdUbx.exdScr.0.fastq.gz", 16, "TGG", "CCAGCTG", properties);
        FastQFileScanner.printPFSM(objectArray);
    }

    public static void printPFSM(Object[] objectArray) {
        DebugLog.log("PSFM : ");
        int n = Array.getLength(objectArray[0]);
        for (int i = 0; i < n; ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            for (Object object : objectArray) {
                stringBuffer.append(Array.get(object, i) + "\t");
            }
            DebugLog.log(stringBuffer.toString());
        }
    }
}

