/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils;

import java.io.PrintStream;
import java.util.EventListener;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.NestedError;

public interface ChangeListener
extends EventListener {
    public static final ChangeListener ALWAYS_VETO = new AlwaysVetoListener();
    public static final ChangeListener LOG_TO_OUT = new LoggingListener(System.out);

    public void postChange(ChangeEvent var1);

    public void preChange(ChangeEvent var1) throws ChangeVetoException;

    public static class AlwaysVetoListener
    implements ChangeListener {
        protected AlwaysVetoListener() {
        }

        public void postChange(ChangeEvent changeEvent) {
            throw new NestedError(new ChangeVetoException(changeEvent, "This object sas been locked"), "Assertion failure: A locked object has been modified");
        }

        public void preChange(ChangeEvent changeEvent) throws ChangeVetoException {
            throw new ChangeVetoException(changeEvent, "This object has been locked");
        }
    }

    public static class LoggingListener
    implements ChangeListener {
        private PrintStream out;

        public LoggingListener(PrintStream printStream) {
            this.out = printStream;
        }

        public void postChange(ChangeEvent changeEvent) {
            this.out.println("postChange for event " + changeEvent);
        }

        public void preChange(ChangeEvent changeEvent) throws ChangeVetoException {
            this.out.println("preChange for event " + changeEvent);
        }
    }
}

