/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class NameParser
implements SymbolParser,
Serializable {
    private FiniteAlphabet alphabet;
    private Map nameToSymbol = new HashMap();

    public NameParser(Map map) {
        this.nameToSymbol = map;
    }

    public NameParser(FiniteAlphabet finiteAlphabet) {
        this.alphabet = finiteAlphabet;
        Iterator iterator = finiteAlphabet.iterator();
        while (iterator.hasNext()) {
            Symbol symbol = (Symbol)iterator.next();
            this.nameToSymbol.put(symbol.getName().toLowerCase(), symbol);
        }
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public SymbolList parse(String string) throws IllegalSymbolException {
        SimpleSymbolList simpleSymbolList = new SimpleSymbolList(this.getAlphabet());
        String[] stringArray = this.nameToSymbol.keySet().toArray(new String[0]);
        while (string.length() > 0) {
            int n = -1;
            int n2 = 0;
            while (n != -1 && n2 < stringArray.length) {
                if (string.startsWith(stringArray[n2])) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n == -1) {
                if (string.length() > 10) {
                    string = string.substring(0, 10);
                }
                throw new IllegalSymbolException("Unable to find symbol name matching from " + string);
            }
            simpleSymbolList.addSymbol(this.parseToken(stringArray[n]));
            string = string.substring(stringArray[n].length());
        }
        return simpleSymbolList;
    }

    public StreamParser parseStream(SeqIOListener seqIOListener) {
        throw new BioError("[FIXME] not implemented");
    }

    public Symbol parseToken(String string) throws IllegalSymbolException {
        Symbol symbol = (Symbol)this.nameToSymbol.get(string.toLowerCase());
        if (symbol == null) {
            throw new IllegalSymbolException("No symbol for token '" + string + "' found in name parser for " + this.getAlphabet().getName());
        }
        return symbol;
    }

    private class NameStreamParser
    implements StreamParser {
        SeqIOListener listener;
        StringBuffer sb = new StringBuffer();

        NameStreamParser(SeqIOListener seqIOListener) {
            this.listener = seqIOListener;
        }

        public void characters(char[] cArray, int n, int n2) {
            this.sb.append(cArray, n, n2);
        }

        public void close() throws IllegalSymbolException {
            SymbolList symbolList = NameParser.this.parse(this.sb.toString());
            this.sb = null;
            Symbol[] symbolArray = new Symbol[symbolList.length()];
            int n = 0;
            while (n < symbolList.length()) {
                symbolArray[n] = symbolList.symbolAt(n + 1);
                ++n;
            }
            try {
                this.listener.addSymbols(NameParser.this.getAlphabet(), symbolArray, 0, symbolArray.length);
            }
            catch (IllegalAlphabetException illegalAlphabetException) {
                throw new BioError(illegalAlphabetException);
            }
        }
    }
}

