/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import org.biojava.bio.dist.AbstractOrderNDistribution;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeListener;

class IndexedNthOrderDistribution
extends AbstractOrderNDistribution {
    private transient Distribution[] dists;
    private transient AlphabetIndex index;

    IndexedNthOrderDistribution(Alphabet alphabet, DistributionFactory distributionFactory) throws IllegalAlphabetException {
        super(alphabet);
        FiniteAlphabet finiteAlphabet = (FiniteAlphabet)this.getConditioningAlphabet();
        this.index = AlphabetManager.getAlphabetIndex(finiteAlphabet);
        this.index.addChangeListener(ChangeListener.ALWAYS_VETO, AlphabetIndex.INDEX);
        this.dists = new Distribution[finiteAlphabet.size()];
        int n = 0;
        while (n < finiteAlphabet.size()) {
            this.dists[n] = distributionFactory.createDistribution(this.getConditionedAlphabet());
            ++n;
        }
    }

    public Collection conditionedDistributions() {
        return Arrays.asList(this.dists);
    }

    public Distribution getDistribution(Symbol symbol) throws IllegalSymbolException {
        return this.dists[this.index.indexForSymbol(symbol)];
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.index = AlphabetManager.getAlphabetIndex((FiniteAlphabet)this.getConditioningAlphabet());
        this.index.addChangeListener(ChangeListener.ALWAYS_VETO, AlphabetIndex.INDEX);
        int n = this.index.getAlphabet().size();
        this.dists = new Distribution[n];
        int n2 = 0;
        while (n2 < n) {
            Symbol symbol = (Symbol)objectInputStream.readObject();
            try {
                this.dists[this.index.indexForSymbol((Symbol)symbol)] = (Distribution)objectInputStream.readObject();
            }
            catch (IllegalSymbolException illegalSymbolException) {
                throw new IOException("Found unexpected symbol: " + illegalSymbolException.getMessage());
            }
            ++n2;
        }
    }

    public void setDistribution(Symbol symbol, Distribution distribution) throws IllegalSymbolException, IllegalAlphabetException {
        int n = this.index.indexForSymbol(symbol);
        if (distribution.getAlphabet() != this.getConditionedAlphabet()) {
            throw new IllegalAlphabetException("The distribution must be over " + this.getConditionedAlphabet() + ", not " + distribution.getAlphabet());
        }
        Distribution distribution2 = this.dists[n];
        if (distribution2 != null && this.weightForwarder != null) {
            distribution2.removeChangeListener(this.weightForwarder);
        }
        if (this.weightForwarder != null) {
            distribution.addChangeListener(this.weightForwarder);
        }
        this.dists[n] = distribution;
    }

    private void writeObject(ObjectOutput objectOutput) throws IOException {
        int n = 0;
        while (n < this.dists.length) {
            objectOutput.writeObject(this.index.symbolForIndex(n));
            objectOutput.writeObject(this.dists[n]);
            ++n;
        }
    }
}

