/*
 * Decompiled with CFR 0.152.
 */
package org.acedb.seq;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.acedb.Ace;
import org.acedb.AceException;
import org.acedb.AceNode;
import org.acedb.AceObject;
import org.acedb.AceSet;
import org.acedb.AceUtils;
import org.acedb.Connection;
import org.acedb.IntValue;
import org.acedb.Reference;
import org.acedb.seq.AceAnnotation;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.seq.impl.FeatureImpl;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Changeable;

public class AceSequence
implements Sequence {
    protected AceObject seqObj;
    private String name;
    private SymbolList symList;
    private Annotation annotation;
    private SimpleFeatureHolder fHolder;

    public AceSequence(AceObject aceObject) throws AceException, BioException {
        this.name = aceObject.getName();
        this.fHolder = new SimpleFeatureHolder();
        try {
            Changeable changeable;
            Object object;
            Object object2;
            Object object3;
            AceNode aceNode;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            AceSet aceSet;
            Object object8;
            this.annotation = new AceAnnotation(aceObject);
            Connection connection = Ace.getConnection(aceObject.toURL());
            String string = connection.transact("Find Sequence " + this.name);
            String string2 = connection.transact("dna");
            SymbolParser symbolParser = this.getAlphabet().getParser("token");
            ArrayList arrayList = new ArrayList();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
            while (stringTokenizer.hasMoreElements()) {
                object8 = stringTokenizer.nextToken();
                if (((String)object8).startsWith(">")) continue;
                if (((String)object8).startsWith("//")) break;
                arrayList.addAll(symbolParser.parse((String)object8).toList());
            }
            this.symList = new SimpleSymbolList(this.getAlphabet(), arrayList);
            connection.dispose();
            object8 = new Feature.Template();
            if (aceObject.contains("Details:") && (aceSet = aceObject.retrieve("Details:")).contains("Subsequence")) {
                object7 = aceSet.retrieve("Subsequence");
                object6 = object7.nameIterator();
                while (object6.hasNext()) {
                    object5 = (String)object6.next();
                    object4 = (Reference)object7.retrieve((String)object5);
                    aceNode = (IntValue)AceUtils.pick((AceSet)object4);
                    object3 = aceNode.iterator();
                    while (object3.hasNext()) {
                        object2 = (IntValue)object3.next();
                        object = new SimpleAnnotation();
                        object.setProperty("references", object4);
                        ((Feature.Template)object8).annotation = object;
                        ((Feature.Template)object8).location = new RangeLocation(aceNode.toInt(), object2.toInt());
                        ((Feature.Template)object8).source = "ACeDB";
                        ((Feature.Template)object8).type = object5;
                        changeable = FeatureImpl.DEFAULT.realizeFeature(this, this, (Feature.Template)object8);
                        this.fHolder.addFeature((Feature)changeable);
                    }
                }
            }
            if (aceObject.contains("Sequence_feature:")) {
                aceSet = aceObject.retrieve("Sequence_feature:");
                object7 = aceSet.nameIterator();
                while (object7.hasNext()) {
                    object6 = (String)object7.next();
                    object5 = aceSet.retrieve((String)object6);
                    object4 = object5.nameIterator();
                    while (object4.hasNext()) {
                        aceNode = (AceNode)object5.retrieve((String)object4.next());
                        object3 = aceNode;
                        object2 = object3.iterator();
                        while (object2.hasNext()) {
                            Object object9;
                            object = (IntValue)object2.next();
                            if (object.size() > 0) {
                                object9 = new StringBuffer();
                                Iterator iterator = object.nameIterator();
                                ((StringBuffer)object9).append(iterator.next());
                                while (iterator.hasNext()) {
                                    ((StringBuffer)object9).append("\n" + iterator.next());
                                }
                                changeable = new SimpleAnnotation();
                                changeable.setProperty("description", ((StringBuffer)object9).toString());
                            } else {
                                changeable = Annotation.EMPTY_ANNOTATION;
                            }
                            ((Feature.Template)object8).location = new RangeLocation(object3.toInt(), object.toInt());
                            ((Feature.Template)object8).source = "ACeDB";
                            ((Feature.Template)object8).type = object6;
                            ((Feature.Template)object8).annotation = changeable;
                            object9 = FeatureImpl.DEFAULT.realizeFeature(this, this, (Feature.Template)object8);
                            this.fHolder.addFeature((Feature)object9);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new AceException(exception, "Fatal error constructing sequence for " + this.name);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    public int countFeatures() {
        return this.fHolder.countFeatures();
    }

    public Feature createFeature(Feature.Template template) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("ACeDB sequences can't be modified");
    }

    public Feature createFeature(FeatureHolder featureHolder, Feature.Template template) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("ACeDB sequences can't be modified");
    }

    public void edit(Edit edit) throws ChangeVetoException {
        throw new ChangeVetoException("Ace sequences are currently immutable");
    }

    public Iterator features() {
        return this.fHolder.features();
    }

    public FeatureHolder filter(FeatureFilter featureFilter, boolean bl) {
        return this.fHolder.filter(featureFilter, bl);
    }

    public Alphabet getAlphabet() {
        return DNATools.getDNA();
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public String getName() {
        return this.name;
    }

    public String getURN() {
        return "urn:sequence/acedb:" + this.getName();
    }

    public Iterator iterator() {
        return this.symList.iterator();
    }

    public int length() {
        return this.symList.length();
    }

    public Feature realizeFeature(Feature.Template template) {
        throw new UnsupportedOperationException("Cannot realize new features on ACeDB sequences.");
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    public void removeFeature(Feature feature) {
        throw new UnsupportedOperationException("ACeDB sequences can't be modified");
    }

    public String seqString() {
        return this.symList.seqString();
    }

    public SymbolList subList(int n, int n2) {
        return this.symList.subList(n, n2);
    }

    public String subStr(int n, int n2) {
        return this.symList.subStr(n, n2);
    }

    public Symbol symbolAt(int n) {
        return this.symList.symbolAt(n);
    }

    public List toList() {
        return this.symList.toList();
    }
}

