/*
 * Decompiled with CFR 0.152.
 */
package edu.oswego.cs.dl.util.concurrent;

import edu.oswego.cs.dl.util.concurrent.BoundedLinkedQueue;
import edu.oswego.cs.dl.util.concurrent.Channel;
import edu.oswego.cs.dl.util.concurrent.Executor;
import edu.oswego.cs.dl.util.concurrent.ThreadFactoryUser;

public class QueuedExecutor
extends ThreadFactoryUser
implements Executor {
    protected Thread thread_;
    protected final Channel queue_;
    protected final RunLoop runLoop_;

    public QueuedExecutor() {
        this(new BoundedLinkedQueue());
    }

    public QueuedExecutor(Channel channel) {
        this.queue_ = channel;
        this.runLoop_ = new RunLoop();
    }

    protected synchronized void clearThread() {
        this.thread_ = null;
    }

    public void execute(Runnable runnable) throws InterruptedException {
        this.restart();
        this.queue_.put(runnable);
    }

    public synchronized Thread getThread() {
        return this.thread_;
    }

    public synchronized void restart() {
        if (this.thread_ == null) {
            this.thread_ = this.threadFactory_.newThread(this.runLoop_);
            this.thread_.start();
        }
    }

    protected class RunLoop
    implements Runnable {
        protected RunLoop() {
        }

        public void run() {
            try {
                try {
                    while (true) {
                        Runnable runnable = (Runnable)QueuedExecutor.this.queue_.take();
                        runnable.run();
                    }
                }
                catch (InterruptedException interruptedException) {
                    Object var3_3 = null;
                    QueuedExecutor.this.clearThread();
                }
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                QueuedExecutor.this.clearThread();
                throw throwable;
            }
        }
    }
}

