/*
 * Decompiled with CFR 0.152.
 */
package fr.cea.ig.metatarget.utils;

public class Measures {
    public static double ARI(int numOfClasses, int numOfBins, long totalNumOfReads, long[] trueNumReadsPerClass, long[][] countsBinPerClass) {
        int c;
        double t1 = 0.0;
        double t2 = 0.0;
        double t3 = 0.0;
        double t4 = 0.0;
        for (c = 1; c <= numOfClasses; ++c) {
            t1 += ((double)trueNumReadsPerClass[c] * (double)trueNumReadsPerClass[c] - 1.0) / 2.0;
        }
        for (int k = 1; k <= numOfBins; ++k) {
            int N_k = 0;
            for (int c2 = 1; c2 <= numOfClasses; ++c2) {
                N_k = (int)((long)N_k + countsBinPerClass[k][c2]);
            }
            t2 += ((double)N_k * (double)N_k - 1.0) / 2.0;
        }
        t3 = 2.0 * t1 * t2 / ((double)totalNumOfReads * ((double)totalNumOfReads - 1.0));
        for (c = 1; c <= numOfClasses; ++c) {
            for (int k = 1; k <= numOfBins; ++k) {
                t4 += ((double)countsBinPerClass[k][c] * (double)countsBinPerClass[k][c] - 1.0) / 2.0;
            }
        }
        double ARI = (t4 - t3) / (0.5 * (t1 + t2) - t3);
        return ARI;
    }

    public static double Homogeneity(int numOfClasses, int numOfBins, long totalNumOfReads, long[] trueNumReadsPerClass, long[][] countsBinPerClassPre) {
        int c;
        int totalNumOfReadsClustered = 0;
        long[][] countsBinPerClass = new long[numOfBins + 1][numOfClasses + 1];
        for (int k = 1; k <= numOfBins; ++k) {
            for (int c2 = 1; c2 <= numOfClasses; ++c2) {
                countsBinPerClass[k][c2] = countsBinPerClassPre[k][c2];
                long[] lArray = countsBinPerClass[0];
                int n = c2;
                lArray[n] = lArray[n] + countsBinPerClassPre[k][c2];
                totalNumOfReadsClustered = (int)((long)totalNumOfReadsClustered + countsBinPerClassPre[k][c2]);
            }
        }
        for (int c3 = 1; c3 <= numOfClasses; ++c3) {
            countsBinPerClass[0][c3] = trueNumReadsPerClass[c3] - countsBinPerClass[0][c3];
        }
        double homogeneity = 0.0;
        double Hck = 0.0;
        for (int k = 1; k <= numOfBins; ++k) {
            int N_k = 0;
            for (c = 1; c <= numOfClasses; ++c) {
                N_k = (int)((long)N_k + countsBinPerClass[k][c]);
            }
            for (c = 1; c <= numOfClasses; ++c) {
                if (countsBinPerClass[k][c] == 0L || N_k == 0) continue;
                Hck -= (double)countsBinPerClass[k][c] / (double)totalNumOfReadsClustered * Math.log((double)countsBinPerClass[k][c] / (double)N_k);
            }
        }
        double Hc = 0.0;
        for (c = 1; c <= numOfClasses; ++c) {
            int N_c = 0;
            for (int k = 1; k <= numOfBins; ++k) {
                N_c = (int)((long)N_c + countsBinPerClass[k][c]);
            }
            if (N_c == 0) continue;
            Hc -= (double)N_c / (double)totalNumOfReadsClustered * Math.log((double)N_c / (double)totalNumOfReadsClustered);
        }
        homogeneity = Hck != 0.0 ? 1.0 - Hck / Hc : 1.0;
        return homogeneity;
    }

    public static double Completeness(int numOfClasses, int numOfBins, long totalNumOfReads, long[] trueNumReadsPerClass, long[][] countsBinPerClassPre) {
        int k;
        int totalNumOfReadsClustered = 0;
        long[][] countsBinPerClass = new long[numOfBins + 1][numOfClasses + 1];
        for (int k2 = 1; k2 <= numOfBins; ++k2) {
            for (int c = 1; c <= numOfClasses; ++c) {
                countsBinPerClass[k2][c] = countsBinPerClassPre[k2][c];
                long[] lArray = countsBinPerClass[0];
                int n = c;
                lArray[n] = lArray[n] + countsBinPerClassPre[k2][c];
                totalNumOfReadsClustered = (int)((long)totalNumOfReadsClustered + countsBinPerClassPre[k2][c]);
            }
        }
        for (int c = 1; c <= numOfClasses; ++c) {
            countsBinPerClass[0][c] = trueNumReadsPerClass[c] - countsBinPerClass[0][c];
        }
        double completeness = 0.0;
        double Hkc = 0.0;
        for (int c = 1; c <= numOfClasses; ++c) {
            int N_c = 0;
            for (k = 0; k <= numOfBins; ++k) {
                N_c = (int)((long)N_c + countsBinPerClass[k][c]);
            }
            for (k = 1; k <= numOfBins; ++k) {
                if (countsBinPerClass[k][c] == 0L || N_c == 0) continue;
                Hkc -= (double)countsBinPerClass[k][c] / (double)totalNumOfReads * Math.log((double)countsBinPerClass[k][c] / (double)N_c);
            }
        }
        double Hk = 0.0;
        for (k = 1; k <= numOfBins; ++k) {
            int N_k = 0;
            for (int c = 1; c <= numOfClasses; ++c) {
                N_k = (int)((long)N_k + countsBinPerClass[k][c]);
            }
            if (N_k == 0) continue;
            Hk -= (double)N_k / (double)totalNumOfReads * Math.log((double)N_k / (double)totalNumOfReads);
        }
        completeness = Hkc != 0.0 ? 1.0 - Hkc / Hk : 1.0;
        return completeness;
    }
}

