/*
 * Decompiled with CFR 0.152.
 */
package base;

import base.ArraysMergerHeap;
import base.CountObject;
import base.Sequence;
import java.util.Iterator;

public class CountObjectIterator
implements Iterator<CountObject> {
    private int[] counts;
    private int countIdx;
    private boolean externalSort = false;
    private int kmerLength;
    private ArraysMergerHeap.MinHeapNode node;

    public CountObjectIterator(int[] nArray, int n) {
        this.counts = nArray;
        this.countIdx = 0;
        this.kmerLength = n;
    }

    public CountObjectIterator(String string) {
        this.node = new ArraysMergerHeap.MinHeapNode(string);
        this.externalSort = true;
    }

    @Override
    public boolean hasNext() {
        if (!this.externalSort) {
            while (this.countIdx < this.counts.length && this.counts[this.countIdx] == 0) {
                ++this.countIdx;
            }
            return this.countIdx < this.counts.length;
        }
        return this.node.peek() != null;
    }

    @Override
    public CountObject next() {
        if (!this.externalSort) {
            CountObject countObject = null;
            while (this.hasNext()) {
                if (this.counts[this.countIdx] <= 0) continue;
                countObject = new CountObject(new Sequence(this.countIdx, this.kmerLength), this.counts[this.countIdx]);
                ++this.countIdx;
                break;
            }
            return countObject;
        }
        CountObject countObject = this.node.peek();
        this.node.pop();
        return countObject;
    }

    @Override
    public void remove() {
    }
}

