/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class GappedSymbolList
extends AbstractSymbolList
implements Serializable {
    private final Alphabet alpha;
    private final SymbolList source;
    private final ArrayList blocks;
    private int length;

    public GappedSymbolList(SymbolList symbolList) {
        this.source = symbolList;
        this.alpha = symbolList.getAlphabet();
        this.blocks = new ArrayList();
        this.length = symbolList.length();
        Block block = new Block(1, this.length, 1, this.length);
        this.blocks.add(block);
    }

    public void addGapInSource(int n) throws IndexOutOfBoundsException {
        this.addGapsInSource(n, 1);
    }

    public void addGapInView(int n) throws IndexOutOfBoundsException {
        this.addGapsInView(n, 1);
    }

    public void addGapsInSource(int n, int n2) {
        Block block;
        if (n < 1 || n > this.length() + 1) {
            throw new IndexOutOfBoundsException("Attempted to add a gap outside of this sequence (1.." + this.length() + ") at " + n);
        }
        int n3 = this.blocks.size() / 2;
        int n4 = 0;
        int n5 = this.blocks.size() - 1;
        do {
            block = (Block)this.blocks.get(n3);
            if (block.sourceStart < n && block.sourceEnd >= n) {
                Block block2 = new Block(n, block.sourceEnd, this.sourceToView(block, n), block.viewEnd);
                block.viewEnd = this.sourceToView(block, n - 1);
                block.sourceEnd = n - 1;
                this.blocks.add(n3 + 1, block2);
                this.renumber(n3 + 1, n2);
                return;
            }
            if (block.sourceStart < n) {
                n4 = n3 + 1;
                n3 = n4 + (n5 - n4) / 2;
                continue;
            }
            n5 = n3 - 1;
            n3 = n4 + (n5 - n4) / 2;
        } while (n4 <= n5);
        if (n3 < this.blocks.size()) {
            block = (Block)this.blocks.get(n3);
            if (block.sourceStart <= n) {
                --n3;
            }
        }
        this.renumber(n3 + 1, n2);
    }

    public void addGapsInView(int n, int n2) throws IndexOutOfBoundsException {
        Block block;
        if (n < 1 || n > this.length() + 1) {
            throw new IndexOutOfBoundsException("Attempted to add a gap outside of this sequence (1.." + this.length() + ") at " + n);
        }
        int n3 = this.blocks.size() / 2;
        int n4 = 0;
        int n5 = this.blocks.size() - 1;
        do {
            block = (Block)this.blocks.get(n3);
            if (block.viewStart < n && block.viewEnd >= n) {
                Block block2 = new Block(this.viewToSource(block, n), block.sourceEnd, n, block.viewEnd);
                block.viewEnd = n - 1;
                block.sourceEnd = this.viewToSource(block, n - 1);
                this.blocks.add(n3 + 1, block2);
                this.renumber(n3 + 1, n2);
                return;
            }
            if (block.viewStart < n) {
                n4 = n3 + 1;
                n3 = n4 + (n5 - n4) / 2;
                continue;
            }
            n5 = n3 - 1;
            n3 = n4 + (n5 - n4) / 2;
        } while (n4 <= n5);
        if (n3 < this.blocks.size()) {
            block = (Block)this.blocks.get(n3);
            if (block.viewStart <= n) {
                --n3;
            }
        } else {
            --n3;
        }
        this.renumber(n3 + 1, n2);
    }

    public void dumpBlocks() {
        Iterator iterator = ((AbstractList)this.blocks).iterator();
        while (iterator.hasNext()) {
            Block block = (Block)iterator.next();
            System.out.println(String.valueOf(block.sourceStart) + ".." + block.sourceEnd + "\t" + block.viewStart + ".." + block.viewEnd);
        }
    }

    protected final int findSourceBlock(int n) {
        int n2 = this.blocks.size() / 2;
        int n3 = 0;
        int n4 = this.blocks.size() - 1;
        do {
            Block block = (Block)this.blocks.get(n2);
            if (block.sourceStart <= n && block.sourceEnd >= n) {
                return n2;
            }
            if (block.sourceStart < n) {
                n3 = n2 + 1;
                n2 = n3 + (n4 - n3) / 2;
                continue;
            }
            n4 = n2 - 1;
            n2 = n3 + (n4 - n3) / 2;
        } while (n3 <= n4);
        throw new BioError("Something is screwed. Could not find source block containing index " + n + " in sequence of length " + this.source.length());
    }

    protected final int findSourceGap(int n) {
        Block block;
        int n2 = this.blocks.size() / 2;
        int n3 = 0;
        int n4 = this.blocks.size() - 1;
        do {
            block = (Block)this.blocks.get(n2);
            if (block.sourceStart <= n && block.sourceEnd >= n) {
                return -1;
            }
            if (block.sourceStart < n) {
                n3 = n2 + 1;
                n2 = n3 + (n4 - n3) / 2;
                continue;
            }
            n4 = n2 - 1;
            n2 = n3 + (n4 - n3) / 2;
        } while (n3 <= n4);
        block = (Block)this.blocks.get(n2);
        if (block.viewEnd < n) {
            return n2;
        }
        return n2 - 1;
    }

    protected final int findViewBlock(int n) {
        int n2 = this.blocks.size() / 2;
        int n3 = 0;
        int n4 = this.blocks.size() - 1;
        do {
            Block block = (Block)this.blocks.get(n2);
            if (block.viewStart <= n && block.viewEnd >= n) {
                return n2;
            }
            if (block.viewStart < n) {
                n3 = n2 + 1;
                n2 = n3 + (n4 - n3) / 2;
                continue;
            }
            n4 = n2 - 1;
            n2 = n3 + (n4 - n3) / 2;
        } while (n3 <= n4);
        return -1;
    }

    protected final int findViewGap(int n) {
        Block block;
        int n2 = this.blocks.size() / 2;
        int n3 = 0;
        int n4 = this.blocks.size() - 1;
        do {
            block = (Block)this.blocks.get(n2);
            if (block.viewStart <= n && block.viewEnd >= n) {
                return -2;
            }
            if (block.viewStart < n) {
                n3 = n2 + 1;
                n2 = n3 + (n4 - n3) / 2;
                continue;
            }
            n4 = n2 - 1;
            n2 = n3 + (n4 - n3) / 2;
        } while (n3 <= n4);
        if (n2 < this.blocks.size()) {
            block = (Block)this.blocks.get(n2);
            if (block.viewEnd < n) {
                return n2;
            }
            return n2 - 1;
        }
        return n2 - 1;
    }

    public int firstNonGap() {
        int n = ((Block)this.blocks.get((int)0)).viewStart;
        return n;
    }

    public Alphabet getAlphabet() {
        return this.alpha;
    }

    public int lastNonGap() {
        int n = ((Block)this.blocks.get((int)(this.blocks.size() - 1))).viewEnd;
        return n;
    }

    public int length() {
        return this.length;
    }

    public void removeGap(int n) throws IndexOutOfBoundsException, IllegalSymbolException {
        if (n < 1 || n > this.length()) {
            throw new IndexOutOfBoundsException("Attempted to remove gap outside of this sequence (1.." + this.length() + ") at " + n);
        }
        int n2 = this.findViewGap(n);
        if (n2 == -2) {
            throw new IllegalSymbolException("Attempted to remove a gap at a non-gap index: " + n + " -> " + this.symbolAt(n).getName());
        }
        if (n2 == -1 || n2 == this.blocks.size() - 1) {
            this.renumber(n2 + 1, -1);
        } else {
            Block block = (Block)this.blocks.get(n2);
            Block block2 = (Block)this.blocks.get(n2 + 1);
            this.renumber(n2 + 1, -1);
            int n3 = block2.viewStart - block.viewEnd;
            if (n3 == 1) {
                block.sourceEnd = block2.sourceEnd;
                block.viewEnd = block2.viewEnd;
                this.blocks.remove(n2 + 1);
            }
        }
    }

    public void removeGaps(int n, int n2) throws IndexOutOfBoundsException, IllegalSymbolException {
        int n3 = n + n2 - 1;
        if (n < 1 || n2 < 1 || n3 > this.length()) {
            throw new IndexOutOfBoundsException("Attempted to remove gap outside of this sequence (1.." + this.length() + ") at (" + n + ".." + n3 + ")");
        }
        int n4 = this.findViewGap(n);
        if (n4 == -2) {
            throw new IllegalSymbolException("Attempted to remove a gap at a non-gap index: " + n + " -> " + this.symbolAt(n).getName());
        }
        if (n4 == -1) {
            Block block = (Block)this.blocks.get(0);
            if (block.viewStart <= n3) {
                throw new IllegalSymbolException("Attempted to remove some non-gap characters at (" + n + ".." + n3 + ")");
            }
            this.renumber(n4 + 1, -n2);
        } else if (n4 == this.blocks.size() - 1) {
            this.length -= n2;
        } else {
            Block block = (Block)this.blocks.get(n4);
            Block block2 = (Block)this.blocks.get(n4 + 1);
            this.renumber(n4 + 1, -n2);
            int n5 = block2.viewStart - block.viewEnd;
            if (n5 < n2) {
                throw new IllegalSymbolException("Attempted to remove some non-gap characters at (" + n + ".." + n3 + ")");
            }
            if (n5 == n2) {
                block.sourceEnd = block2.sourceEnd;
                block.viewEnd = block2.viewEnd;
                this.blocks.remove(n4 + 1);
            }
        }
    }

    protected final void renumber(int n, int n2) {
        int n3 = n;
        while (n3 < this.blocks.size()) {
            Block block = (Block)this.blocks.get(n3);
            block.viewStart += n2;
            block.viewEnd += n2;
            ++n3;
        }
        this.length += n2;
    }

    public final int sourceToView(int n) throws IndexOutOfBoundsException {
        if (n < 1 || n > this.source.length()) {
            throw new IndexOutOfBoundsException("Attempted to address source sequence (1.." + this.length() + ") at " + n);
        }
        int n2 = this.findSourceBlock(n);
        return this.sourceToView((Block)this.blocks.get(n2), n);
    }

    protected final int sourceToView(Block block, int n) {
        return n - block.sourceStart + block.viewStart;
    }

    public Symbol symbolAt(int n) throws IndexOutOfBoundsException {
        if (n > this.length() || n < 1) {
            throw new IndexOutOfBoundsException("Attempted to read outside of this sequence (1.." + this.length() + ") at " + n);
        }
        int n2 = this.findViewBlock(n);
        if (n2 == -1) {
            return AlphabetManager.getGapSymbol();
        }
        Block block = (Block)this.blocks.get(n2);
        return this.source.symbolAt(block.sourceStart - block.viewStart + n);
    }

    public final int viewToSource(int n) throws IndexOutOfBoundsException {
        if (n < 1 || n > this.length()) {
            throw new IndexOutOfBoundsException("Attempted to address sequence (1.." + this.length() + ") at " + n);
        }
        int n2 = this.findViewBlock(n);
        if (n2 == -1) {
            return -1;
        }
        return this.viewToSource((Block)this.blocks.get(n2), n);
    }

    protected final int viewToSource(Block block, int n) {
        return n - block.viewStart + block.sourceStart;
    }

    private final class Block
    implements Serializable {
        public int sourceStart;
        public int sourceEnd;
        public int viewStart;
        public int viewEnd;

        public Block(int n, int n2, int n3, int n4) {
            this.sourceStart = n;
            this.sourceEnd = n2;
            this.viewStart = n3;
            this.viewEnd = n4;
        }
    }
}

