/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.seq.db.HashSequenceDB;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.db.SequenceDBInstallation;
import org.biojava.utils.ObjectUtil;
import org.biojava.utils.contract.Contract;

public class SimpleSequenceDBInstallation
implements SequenceDBInstallation {
    private Map sequenceDBByIdentifier = new HashMap();

    public synchronized void addSequenceDB(String string, Set set) {
        Object object;
        Contract.pre(string != null, "name was null");
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        if (set != null) {
            hashSet.addAll(set);
        }
        Set set2 = this.sequenceDBByIdentifier.keySet();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            Contract.pre(object instanceof String, "otherIdentifiers must be a Set of String objects");
            Contract.pre(set2.contains(object) ^ true, "name and otherIdentifiers must not already be in use");
        }
        object = new HashSequenceDB(string);
        Iterator iterator2 = hashSet.iterator();
        while (iterator2.hasNext()) {
            String string2 = (String)iterator2.next();
            this.sequenceDBByIdentifier.put(string2, object);
        }
    }

    public synchronized void addSequenceDB(SequenceDB sequenceDB, Set set) {
        Iterator iterator;
        Contract.pre(sequenceDB != null, "SequenceDB was null");
        String string = sequenceDB.getName();
        Contract.pre(string != null, "SequenceDB name was null");
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        if (set != null) {
            hashSet.addAll(set);
        }
        Set set2 = this.sequenceDBByIdentifier.keySet();
        Iterator iterator2 = hashSet.iterator();
        while (iterator2.hasNext()) {
            iterator = iterator2.next();
            Contract.pre(iterator instanceof String, "otherIdentifiers must be a set of String objects");
            Contract.pre(set2.contains(iterator) ^ true, "name and otherIdentifiers must not already be in use");
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            this.sequenceDBByIdentifier.put(string2, sequenceDB);
        }
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        SimpleSequenceDBInstallation simpleSequenceDBInstallation = (SimpleSequenceDBInstallation)object;
        return ObjectUtil.equals(this.sequenceDBByIdentifier, simpleSequenceDBInstallation.sequenceDBByIdentifier);
    }

    public synchronized SequenceDB getSequenceDB(String string) {
        Contract.pre(string != null, "identifier was null");
        return (SequenceDB)this.sequenceDBByIdentifier.get(string);
    }

    public synchronized Set getSequenceDBs() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.sequenceDBByIdentifier.values());
        return hashSet;
    }

    public synchronized int hashCode() {
        int n = 0;
        n = ObjectUtil.hashCode(n, this.sequenceDBByIdentifier);
        return n;
    }

    public static void main(String[] stringArray) {
        System.out.println("Create sequence db installation");
        SimpleSequenceDBInstallation simpleSequenceDBInstallation = new SimpleSequenceDBInstallation();
        System.out.println("Sequence db installation serves " + simpleSequenceDBInstallation.getSequenceDBs().size() + " sequence dbs");
        System.out.println("add swissprot (aka sprot, sp) and genbank (aka gb) do sequence db installation");
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("sprot");
        hashSet.add("sp");
        simpleSequenceDBInstallation.addSequenceDB("swissprot", hashSet);
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add("gb");
        hashSet2.add("genbank");
        simpleSequenceDBInstallation.addSequenceDB("genbank", hashSet2);
        System.out.println("Sequence db installation serves " + simpleSequenceDBInstallation.getSequenceDBs().size() + " sequence dbs");
        System.out.println("Sequence db associated with identifier \"sprot\" is: " + simpleSequenceDBInstallation.getSequenceDB("sprot"));
        System.out.println("Sequence db associated with identifier \"swissprot\" is: " + simpleSequenceDBInstallation.getSequenceDB("swissprot"));
        System.out.println("Sequence db associated with identifier \"sp\" is: " + simpleSequenceDBInstallation.getSequenceDB("sp"));
        System.out.println("Sequence db associated with identifier \"willi\" is: " + simpleSequenceDBInstallation.getSequenceDB("willi"));
        System.out.println("Sequence db associated with identifier \"gb\" is: " + simpleSequenceDBInstallation.getSequenceDB("gb"));
        System.out.println("Sequence db associated with identifier \"genbank\" is: " + simpleSequenceDBInstallation.getSequenceDB("genbank"));
        System.out.println("Sequence db associated with identifier \"genebank\" is: " + simpleSequenceDBInstallation.getSequenceDB("genebank"));
    }

    public String toString() {
        return "SimpleSequenceDBInstallation: " + this.sequenceDBByIdentifier.values();
    }
}

