/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.seq.AbstractFeatureHolder;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;

public class MergeFeatureHolder
extends AbstractFeatureHolder {
    private Set featureHolders = new HashSet();

    public void addFeatureHolder(FeatureHolder featureHolder) {
        this.featureHolders.add(featureHolder);
    }

    public boolean containsFeature(Feature feature) {
        Iterator iterator = this.featureHolders.iterator();
        while (iterator.hasNext()) {
            if (!((FeatureHolder)iterator.next()).containsFeature(feature)) continue;
            return true;
        }
        return false;
    }

    public int countFeatures() {
        int n = 0;
        Iterator iterator = this.featureHolders.iterator();
        while (iterator.hasNext()) {
            n += ((FeatureHolder)iterator.next()).countFeatures();
        }
        return n;
    }

    public Iterator features() {
        return new MFHIterator();
    }

    public FeatureHolder filter(FeatureFilter featureFilter, boolean bl) {
        MergeFeatureHolder mergeFeatureHolder = new MergeFeatureHolder();
        Iterator iterator = this.featureHolders.iterator();
        while (iterator.hasNext()) {
            FeatureHolder featureHolder = (FeatureHolder)iterator.next();
            mergeFeatureHolder.addFeatureHolder(featureHolder.filter(featureFilter, bl));
        }
        return mergeFeatureHolder;
    }

    public void removeFeatureHolder(FeatureHolder featureHolder) {
        this.featureHolders.remove(featureHolder);
    }

    private class MFHIterator
    implements Iterator {
        private Iterator fhIterator;
        private Iterator fIterator;

        public MFHIterator() {
            this.fhIterator = MergeFeatureHolder.this.featureHolders.iterator();
            this.fIterator = this.fhIterator.hasNext() ? ((FeatureHolder)this.fhIterator.next()).features() : Collections.EMPTY_SET.iterator();
        }

        public boolean hasNext() {
            if (this.fIterator.hasNext()) {
                return true;
            }
            if (this.fhIterator.hasNext()) {
                this.fIterator = ((FeatureHolder)this.fhIterator.next()).features();
                return this.hasNext();
            }
            return false;
        }

        public Object next() {
            if (this.fIterator.hasNext()) {
                return this.fIterator.next();
            }
            if (this.fhIterator.hasNext()) {
                this.fIterator = ((FeatureHolder)this.fhIterator.next()).features();
                return this.next();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

