/*
 * Decompiled with CFR 0.152.
 */
package eponine.model;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.BioError;
import stats.glm.BasisFunction;
import stats.glm.BasisSource;
import stats.glm.SLMTrainingContext;

public class SequentialBasisSource
extends AbstractCollection
implements BasisSource {
    private List basisSourceList = new ArrayList();
    private Iterator theIterator;
    private BasisSource currentSource;

    public Iterator iterator() {
        return this.basisSourceList.iterator();
    }

    public int size() {
        return this.basisSourceList.size();
    }

    private Iterator getCurrentIterator() {
        if (this.theIterator == null) {
            this.theIterator = this.iterator();
        }
        return this.theIterator;
    }

    private BasisSource getCurrentSource(SLMTrainingContext sLMTrainingContext) {
        while (this.currentSource == null || !this.currentSource.hasNext(sLMTrainingContext)) {
            Iterator iterator = this.getCurrentIterator();
            if (iterator.hasNext()) {
                this.currentSource = (BasisSource)iterator.next();
                continue;
            }
            return null;
        }
        return this.currentSource;
    }

    public boolean add(Object object) {
        if (this.theIterator != null) {
            throw new BioError("Can't add sources to a SequentialBasisSource after calling next()");
        }
        this.basisSourceList.add(object);
        return true;
    }

    public BasisFunction next(SLMTrainingContext sLMTrainingContext) {
        BasisSource basisSource = this.getCurrentSource(sLMTrainingContext);
        if (basisSource == null) {
            return null;
        }
        return basisSource.next(sLMTrainingContext);
    }

    public boolean hasNext(SLMTrainingContext sLMTrainingContext) {
        BasisSource basisSource = this.getCurrentSource(sLMTrainingContext);
        if (basisSource == null) {
            return false;
        }
        return basisSource.hasNext(sLMTrainingContext);
    }
}

