## ----setup, include=FALSE-----------------------------------------------------
library(knitr)
opts_chunk$set(
        collapse = TRUE,
        comment = "#>", 
        fig.align = 'center',
        warning = FALSE, 
        message = FALSE
)

library(dominatR)
library(dominatRData)
library(airway)
library(ggplot2)


## ----installation, eval = FALSE-----------------------------------------------
# library(BiocManager)
# BiocManager::install('dominatR')

## ----se_norm, eval = TRUE, echo = TRUE, message = FALSE-----------------------
data("airway")

se = quantile_normalization(airway, new_assay_name = 'quantile_norma')

head(se)
head(assay(se, 'quantile_norma'))

## ----df_norm, eval = TRUE, echo = TRUE, message = FALSE-----------------------
data("atac_tissue_counts")

## selecting the numeric columns
norm = atac_tissue_counts[,8:26]

norm1 = quantile_normalization(norm)

head(norm1[,1:10])

## ----se_entr, eval = TRUE, echo = TRUE, message = FALSE-----------------------

se = entropy(se)

head(se)

### It creates a new column in the rowData dataframe
head(rowData(se))

## ----df_entr, eval = TRUE, echo = TRUE, message = FALSE-----------------------

norm1 = entropy(norm)

### It creates a new column in the dataframe
head(norm1[,10:20])

## ----rope_pol3, eval = TRUE, echo = TRUE, message = FALSE---------------------
data("rnapol_score")

data1 <- rnapol_score[,6:7]

plot_rope(
        data1, 
        rope_color = 'white',
        pch = c(21, 21), 
        push_text = 1.2,
        col = c('#7eb1d5', '#fa8451'),
        output_table = FALSE,
        rope_width = 1
)

title(main = 'Gene Occupancy RNA Pol II vs RNA Pol III',
        font.main = 1, 
        cex = 0.5)

## ----rope_pol3_filt, eval = TRUE, echo = TRUE, message = FALSE----------------

plot_rope(
        data1, 
        rope_color = 'white',
        pch = c(21, 21), 
        col = c('#7eb1d5', '#fa8451'),
        push_text = 1.2,
        output_table = FALSE,
        rope_width = 1,
        entropyrange = c(0, 0.5),
        maxvaluerange = c(1.3, Inf)
)


title(main = 'Gene Occupancy \n RNA Pol II vs RNA Pol III - Specific',
        font.main = 1, 
        cex = 0.5)

## ----rope_pol3_filt1, eval = TRUE, echo = TRUE, message = FALSE---------------

plot_rope(
        data1,
        pch = c(21,21), 
        push_text = 1.2,
        rope_color = 'white',
        col = c('#7eb1d5', '#fa8451'),
        output_table = FALSE,
        rope_width = 1,
        entropyrange = c(0.8, 1),
        maxvaluerange = c(1.3, Inf)
)

title(main = 'Gene Occupancy \n RNA Pol II vs RNA Pol III - Shared',
        font.main = 1, 
        cex = 0.5)


## ----trin_pol3, eval = TRUE, echo = TRUE, message = FALSE---------------------
data1 <- rnapol_score[,5:7]

plot_triangle(data1,
                output_table = FALSE,
                col = c('#ff80e3', '#7eb1d5', '#fa8451'),
                label = TRUE, pch = 21, 
                push_text = 1.3)

title(main = 'Gene Occupancy \n Pol I vs Pol II vs Pol III',
        font.main = 1, 
        cex = 0.5)

## ----trin_pol3_filt, eval = TRUE, echo = TRUE, message = FALSE----------------
data1 <- rnapol_score[,5:7]

plot_triangle(data1, 
                output_table = FALSE, 
                col = c('#ff80e3', '#7eb1d5', '#fa8451'),
                entropyrange = c(0,0.5),
                label = TRUE, pch = 21,
                push_text = 1.3)

title(main = 'Gene Occupancy \n Pol I vs Pol II vs Pol III - Specific',
        font.main = 1, 
        cex = 0.5)


## ----trin_pol3_filt1, eval = TRUE, echo = TRUE, message = FALSE---------------
data1 <- rnapol_score[,5:7]

plot_triangle(data1, 
                output_table = FALSE, 
                col = c('#ff80e3', '#7eb1d5', '#fa8451'),
                entropyrange = c(1.5, Inf),
                label = TRUE, pch = 21,
                push_text = 1.3)

title(main = 'Gene Occupancy \n Pol I vs Pol II vs Pol III - Shared',
        font.main = 1, 
        cex = 0.5)


## ----circ_tiss, eval = TRUE, echo = TRUE, message = FALSE---------------------
data("atac_tissue_score")

### subsetting only a set of numerical columns
data1 = atac_tissue_score[,8:26]


plot_circle(data1, 
            point_line_colors = rep('black', 19),
            magnituderange = c(1, Inf),
            n = 19, 
            output_table = FALSE, 
            point_size = 3) + 
ggtitle('Pol III transcribed genes \n accessibility across tissues')


## ----circ_tiss_filt1, eval = TRUE, echo = TRUE, message = FALSE---------------
data("atac_tissue_score")


plot_circle(data1, 
            point_line_colors = rep('black', 19),
            entropyrange = c(0,1), 
            magnituderange = c(1, Inf),
            straight_points = FALSE, 
            n = 19, 
            output_table = FALSE, 
            point_size = 3) + 
ggtitle('Pol III transcribed genes \n accessibility across tissues - Unique')

## ----circ_tiss_filt2, eval = TRUE, echo = TRUE, message = FALSE---------------
data("atac_tissue_score")

plot_circle(data1, 
            point_line_colors = rep('black', 19),
            entropyrange = c(4, Inf),
            magnituderange = c(1, Inf),
            n = 19, 
            output_table = FALSE,
            point_size = 3) + 
ggtitle('Pol III transcribed genes \n accessibility across tissues - Shared')

## ----session-info, echo=FALSE-------------------------------------------------
sessionInfo()

