% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_cutadapt.R
\name{make_cutadapt}
\alias{make_cutadapt}
\title{Trims/filter fastq using external cutadapt/fastq_quality_filter}
\usage{
make_cutadapt(input, output, parse = NULL, threads = 1)
}
\arguments{
\item{input}{Character path to a directory containing input fastq-files. The
script will recursively search this directory for the .fastq|.fastq.gz
extension.}

\item{output}{Character path to the output directory where trimmed fastq files
will be stored and temporary files will be generated.}

\item{parse}{List with two character string expressions. The first will be
parsed to cutadapt while the other is be parsed to fastq_quality_filter. If
any is NULL, then the function will not pass the command and the trimming or
filtering will not be applied. Thus, if parse = list(cutadapt=NULL,
fastq_quality_filter="-q 20 -p 80"), then only the quality filter will be
applied.}

\item{threads}{Integer stating the number of parallel jobs. Note, that
reading multiple fastq files drains memory fast, using up to 10Gb per fastq
file. To avoid crashing the system due to memory shortage, make sure that
each thread on the machine have at least 10 Gb of memory available, unless
your fastq files are very small. Use \code{parallel::detectcores()} to see
available threads on the machine.}
}
\value{
Externally the function will generate trimmed and/or quality filtered
fastq files in the output folder. Internally, a list of logs that can be used
to generate a progress report is returned.
}
\description{
\code{make_cuadapt} cutadapt/fastq_quality_filter
}
\details{
Given a path to sequence files in fastq format this function will trim adaptor
and remove sequences with low quality.
}
\examples{
 
############################################################      
### Principle of trimming using the make_cutadapt function
### (Important: Need external installations of cutadapt 
###  and fastq_quality_filter to work)
#  
#   input = "/some/path/to/input/folder"
#   output =  "/some/path/to/output/folder"
# 
## Parse for make_cutadapt is a list of 2 character string expressions.
## The first is parsed to cutadapt and the other to fastq_quality_filter 
## For parallel processes '-j 1' is recommended since seqpac will   
## parallelize across samples and not within.
## Run system2("cutadapt -h", stdout=TRUE) and 
## system("fastq_quality_filter -h", stdout=TRUE) 
## for more options.
#   
## String to parse to cutadapt:
# cut_prs <- paste0("-j 1 -a AGATCGGAAGAGCACACGTCTGAACTCCAGTCACAT",
#                    " --discard-untrimmed --nextseq-trim=20",
#                    " -O 10 -m 7 -M 70")
# 
## Add string to parse to fastq_quality_filter:
#  parse = list(
#            cutadapt=cut_prs,
#            fastq_quality_filter="-q 20 -p 80")
#               
#  logs  <-  make_cutadapt(input, output, threads=8, parse=parse)

#' # Clean up temp
closeAllConnections()
fls_temp  <- list.files(tempdir(), recursive=TRUE, full.names = TRUE)
file.remove(fls_temp, showWarnings=FALSE)   
 
}
\seealso{
\url{https://cutadapt.readthedocs.io/en/stable/} for download and
documentation on cutadapt.
\url{http://hannonlab.cshl.edu/fastx_toolkit/commandline.html} for download
and documentation on fastq_quality_filter. \url{https://github.com/OestLab/seqpac}
for updates on seqpac.

Other PAC generation: 
\code{\link{PAC_check}()},
\code{\link{PAC_create}()},
\code{\link{make_PAC}()},
\code{\link{make_counts}()},
\code{\link{make_pheno}()},
\code{\link{make_trim}()},
\code{\link{merge_lanes}()}
}
\concept{PAC generation}
