% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PAC_saturation.R
\name{PAC_saturation}
\alias{PAC_saturation}
\title{Filter a PAC object on sequence size and coverage}
\usage{
PAC_saturation(PAC, resample = 10, steps = 10, thresh = c(1, 10), threads = 1)
}
\arguments{
\item{PAC}{PAC-list object containing a Counts data.frame with sequences as
row names and samples as column names.}

\item{resample}{Integer setting the number of permutations at each percentage
step (default=10).}

\item{steps}{Integer defining the number of percentage steps between 0-100% of the
original dataset (default=10).}

\item{thresh}{Integer vector containing mean count thresholds that will be
targeted. Default is set to c(1,10), where each new occurrence reaching 1
count (>=1) and each new occurrence reaching 10 counts (>=10) will be
analyzed.}

\item{threads}{Number of cores to be used for performing the permutations.}
}
\value{
A list with ggplot2 graph objects: The 1:st graph shows
  saturation/diversity result at the 1:st threshold. The 2:nd graph shows
  saturation/diversity result at the 2:nd threshold, etc.
}
\description{
\code{PAC_saturation} Performs an sequence diversity/saturation analysis on a
PAC objects.
}
\details{
Given a PAC object the function will perform a sequence saturation analysis.
This is done by downsampling the original dataset by permutation at different
percentages of the original dataset. The closer the curve at the original
sequence depth (100%) is to a plateau phase the more saturated is the
diversity of sequences for the original dataset. Approaching the plateau
usually means that the sequencing depth of the library have sampled the full
population of sequences available in the sample. Here we use an none-linear
least square (\code{\link{nls}}) model with a self-starter for asymptotic
regression (\code{SSasympt}) to describe the rate in which the library
approaches the plateau.
}
\examples{


# OBS! The example below is using already down-sampled data. Still, sequence
# diversity is rather saturated on >=1 occurrence. meaning that most sequences
# in the samples has been caught. Nonetheless, sequences reaching >=2
# occurrences have not plateaued.

load(system.file("extdata", "drosophila_sRNA_pac_filt_anno.Rdata", 
                  package = "seqpac", mustWork = TRUE))

plot_lst  <- PAC_saturation(pac, resample=10, steps=10, 
                            thresh=c(1,2), threads=1)
names(plot_lst)
cowplot::plot_grid(plotlist=plot_lst)

}
\seealso{
\url{https://github.com/OestLab/seqpac} for updates on the current
  package.

Other PAC analysis: 
\code{\link{PAC_covplot}()},
\code{\link{PAC_deseq}()},
\code{\link{PAC_filter}()},
\code{\link{PAC_filtsep}()},
\code{\link{PAC_gtf}()},
\code{\link{PAC_jitter}()},
\code{\link{PAC_mapper}()},
\code{\link{PAC_nbias}()},
\code{\link{PAC_norm}()},
\code{\link{PAC_pca}()},
\code{\link{PAC_pie}()},
\code{\link{PAC_sizedist}()},
\code{\link{PAC_stackbar}()},
\code{\link{PAC_summary}()},
\code{\link{PAC_trna}()},
\code{\link{as.PAC}()},
\code{\link{filtsep_bin}()},
\code{\link{map_rangetype}()},
\code{\link{tRNA_class}()}
}
\concept{PAC analysis}
