% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PAC_filtsep.R
\name{PAC_filtsep}
\alias{PAC_filtsep}
\title{Generates filtered sequence name list separated on group}
\usage{
PAC_filtsep(
  PAC,
  norm = "counts",
  threshold = 10,
  coverage = 100,
  pheno_target = NULL,
  output = "sequence"
)
}
\arguments{
\item{PAC}{PAC-list object containing an Pheno data.frame with samples as row
names and a Counts table with raw counts or normalized counts table
containing for example counts per million (cpm; generated by
\code{PAC_norm}).}

\item{norm}{Character specifying if filtering should be done using "counts",
"cpm" or another normalized data table in PAC$norm (default="counts").}

\item{threshold}{Integer giving the threshold in counts PAC$Counts or
normalized counts (table in PAC$norm) that needs to be reached for a
sequence to be included (default=10).}

\item{coverage}{Integer giving the percent of independent samples of each
group that needs to reach the threshold for a sequence to be included
(default=100).}

\item{pheno_target}{(optional) List with: 
1st object being a character vector of target column in Pheno, 
2nd object being a character vector of the target group(s) 
in the target Pheno column (1st object).
(default=NULL)}

\item{output}{Specifies the output format. If output="sequence" (default),
then a data.frame is returned  where each column contains the sequences
names that passed the filter for a specific group specified in
pheno_target. If output="binary", then the resulting data.frame will be
converted into a binary (hit=1, no hit=0) data.frame. See
\code{\link{filtsep_bin}}.}
}
\value{
A data.frame (see output for details).
}
\description{
\code{PAC_filtsep} Group separated filtered name list
}
\details{
Given a PAC object the function will extract sequences within the
given filter within a given group.
}
\examples{

load(system.file("extdata", "drosophila_sRNA_pac_filt_anno.Rdata", 
                  package = "seqpac", mustWork = TRUE))

## Keep sequences with 5 counts (threshold) in 100\% (coverage) of 
## samples in a group:
 # Use PAC_filtsep to find sequences 
 filtsep <- PAC_filtsep(pac, norm="counts", threshold=5, 
                        coverage=100, pheno_target= list("stage"))
                        
 # Filter by unique sequences passing filtsep  
 filtsep <- unique(do.call("c", as.list(filtsep)))
 pac_filt <- PAC_filter(pac, subset_only = TRUE, anno_target= filtsep)
 
 # Find overlap
 olap <- reshape2::melt(filtsep, 
                        measure.vars = c("Stage1", "Stage3", "Stage5"), 
                        na.rm=TRUE)
                        
## Upset plot using the UpSetR package
 # (when output="binary" PAC_filtsep uses filtsep_bin for binary conversion
 # Use PAC_filtsep with binary output
 filtsep_bin <- PAC_filtsep(pac, norm="counts", threshold=5, 
                            coverage=100, pheno_target= list("stage"), 
                            output="binary")
 
# Plot Wenn diagram or UpSetR
#
# plot(venneuler::venneuler(data.frame(olap[,2], olap[,1]))) 
#
# UpSetR::upset(filtsep_bin, sets = colnames(filtsep_bin), 
#              mb.ratio = c(0.55, 0.45), order.by = "freq", keep.order=TRUE)
           

 
}
\seealso{
\url{https://github.com/OestLab/seqpac} for updates on the current
  package.

Other PAC analysis: 
\code{\link{PAC_covplot}()},
\code{\link{PAC_deseq}()},
\code{\link{PAC_filter}()},
\code{\link{PAC_gtf}()},
\code{\link{PAC_jitter}()},
\code{\link{PAC_mapper}()},
\code{\link{PAC_nbias}()},
\code{\link{PAC_norm}()},
\code{\link{PAC_pca}()},
\code{\link{PAC_pie}()},
\code{\link{PAC_saturation}()},
\code{\link{PAC_sizedist}()},
\code{\link{PAC_stackbar}()},
\code{\link{PAC_summary}()},
\code{\link{PAC_trna}()},
\code{\link{as.PAC}()},
\code{\link{filtsep_bin}()},
\code{\link{map_rangetype}()},
\code{\link{tRNA_class}()}
}
\concept{PAC analysis}
