% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align_based_quan.R
\name{align_based_quan}
\alias{align_based_quan}
\title{alignment-based workflow}
\usage{
align_based_quan(
  pair,
  taxa,
  genome,
  annotation,
  novel_transcript = FALSE,
  threads = 4,
  hisat2_build_add = NULL,
  hisat2_add = NULL,
  stringtie_add = NULL
)
}
\arguments{
\item{pair}{'single' for single-end (SE) or 'paired' for paired-end (PE) reads.}

\item{taxa}{the scientific or common name of the organism.}

\item{genome}{the reference genome.}

\item{annotation}{the annotation file.}

\item{novel_transcript}{logic, whether identifying novel transcripts is expected or not. Default is FALSE.}

\item{threads}{the number of threads to be used. Default is 4.}

\item{hisat2_build_add}{additional parameters to customize hisat2 build command. Default is NULL.}

\item{hisat2_add}{additional parameters to customize hisat2 command. Default is NULL.}

\item{stringtie_add}{additional parameters to customize stringtie command. Default is NULL.}
}
\value{
None
}
\description{
alignment-based workflow
}
\examples{
\dontrun{
test_Homo_sapiens.fna <- system.file('extdata', 'test_Homo_sapiens.fna', package = 'BP4RNAseq')
test_Homo_sapiens.gff <- system.file('extdata', 'test_Homo_sapiens.gff', package = 'BP4RNAseq')
align_based_quan(pair = 'paired', taxa = 'Homo sapiens', 
genome = test_Homo_sapiens.fna, 
annotation = test_Homo_sapiens.gff, novel_transcript = FALSE)
}

}
