% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_clus.R
\name{vis_clus}
\alias{vis_clus}
\title{Sample spatial cluster visualization}
\usage{
vis_clus(
  spe,
  sampleid = unique(spe$sample_id)[1],
  clustervar,
  colors = c("#b2df8a", "#e41a1c", "#377eb8", "#4daf4a", "#ff7f00", "gold", "#a65628",
    "#999999", "black", "grey", "white", "purple"),
  spatial = TRUE,
  image_id = "lowres",
  alpha = NA,
  point_size = 2,
  auto_crop = TRUE,
  na_color = "#CCCCCC40",
  is_stitched = FALSE,
  guide_point_size = point_size,
  ...
)
}
\arguments{
\item{spe}{A
\link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class}
object. See \code{\link[=fetch_data]{fetch_data()}} for how to download some example objects or
\code{\link[=read10xVisiumWrapper]{read10xVisiumWrapper()}} to read in \code{spaceranger --count} output files and
build your own \code{spe} object.}

\item{sampleid}{A \code{character(1)} specifying which sample to plot from
\code{colData(spe)$sample_id} (formerly \code{colData(spe)$sample_name}).}

\item{clustervar}{A \code{character(1)} with the name of the \code{colData(spe)}
column that has the cluster values.}

\item{colors}{A vector of colors to use for visualizing the clusters
from \code{clustervar}. If the vector has names, then those should match the
values of \code{clustervar}.}

\item{spatial}{A \code{logical(1)} indicating whether to include the histology
layer from \code{\link[=geom_spatial]{geom_spatial()}}. If you plan to use
\link[plotly:ggplotly]{ggplotly()} then it's best to set this to \code{FALSE}.}

\item{image_id}{A \code{character(1)} with the name of the image ID you want to
use in the background.}

\item{alpha}{A \code{numeric(1)} in the \verb{[0, 1]} range that specifies the
transparency level of the data on the spots.}

\item{point_size}{A \code{numeric(1)} specifying the size of the points. Defaults
to \code{1.25}. Some colors look better if you use \code{2} for instance.}

\item{auto_crop}{A \code{logical(1)} indicating whether to automatically crop
the image / plotting area, which is useful if the Visium capture area is
not centered on the image and if the image is not a square.}

\item{na_color}{A \code{character(1)} specifying a color for the NA values.
If you set \code{alpha = NA} then it's best to set \code{na_color} to a color that has
alpha blending already, which will make non-NA values pop up more and the NA
values will show with a lighter color. This behavior is lost when \code{alpha} is
set to a non-\code{NA} value.}

\item{is_stitched}{A \code{logical(1)} vector: If \code{TRUE}, expects a
\link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class} built
with \code{visiumStitched::build_spe()}.
\url{http://research.libd.org/visiumStitched/reference/build_spe.html}; in
particular, expects a logical colData column \code{exclude_overlapping}
specifying which spots to exclude from the plot. Sets \code{auto_crop = FALSE}.}

\item{guide_point_size}{A \code{numeric(1)} specifying the size of the points in
guide. Defaults to \code{point_size}. Increase to improve visability.}

\item{...}{Passed to \link[base:paste]{paste0()} for making the title of the
plot following the \code{sampleid}.}
}
\value{
A \link[ggplot2:ggplot]{ggplot2} object.
}
\description{
This function visualizes the clusters for one given sample at the spot-level
using (by default) the histology information on the background. To visualize
gene-level (or any continuous variable) use \code{\link[=vis_gene]{vis_gene()}}.
}
\details{
This function subsets \code{spe} to the given sample and prepares the
data and title for \code{\link[=vis_clus_p]{vis_clus_p()}}.
}
\examples{

if (enough_ram()) {
    ## Obtain the necessary data
    if (!exists("spe")) spe <- fetch_data("spe")

    ## Check the colors defined by Lukas M Weber
    libd_layer_colors

    ## Use the manual color palette by Lukas M Weber
    p1 <- vis_clus(
        spe = spe,
        clustervar = "layer_guess_reordered",
        sampleid = "151673",
        colors = libd_layer_colors,
        ... = " LIBD Layers"
    )
    print(p1)

    ## Without auto-cropping the image
    p2 <- vis_clus(
        spe = spe,
        clustervar = "layer_guess_reordered",
        sampleid = "151673",
        colors = libd_layer_colors,
        auto_crop = FALSE,
        ... = " LIBD Layers"
    )
    print(p2)

    ## Without histology
    p3 <- vis_clus(
        spe = spe,
        clustervar = "layer_guess_reordered",
        sampleid = "151673",
        colors = libd_layer_colors,
        ... = " LIBD Layers",
        spatial = FALSE
    )
    print(p3)

    ## With some NA values
    spe$tmp <- spe$layer_guess_reordered
    spe$tmp[spe$sample_id == "151673"][seq_len(500)] <- NA
    p4 <- vis_clus(
        spe = spe,
        clustervar = "tmp",
        sampleid = "151673",
        colors = libd_layer_colors,
        na_color = "white",
        ... = " LIBD Layers"
    )
    print(p4)
    
    ## edit plot point size but keep guide size larger
    p5 <- vis_clus(
        spe = spe,
        clustervar = "layer_guess_reordered",
        sampleid = "151673",
        colors = libd_layer_colors,
        na_color = "white",
        point_size = 1,
        guide_point_size = 3,
        ... = " LIBD Layers"
    )
    print(p5)
         
}
}
\seealso{
Other Spatial cluster visualization functions: 
\code{\link{frame_limits}()},
\code{\link{vis_clus_p}()},
\code{\link{vis_grid_clus}()},
\code{\link{vis_image}()}
}
\concept{Spatial cluster visualization functions}
