% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_stitched_data.R
\name{prep_stitched_data}
\alias{prep_stitched_data}
\title{Prepare stitched data for plotting}
\usage{
prep_stitched_data(spe, point_size, image_id)
}
\arguments{
\item{spe}{A \code{SpatialExperiment} built with
\code{visiumStitched::build_spe()}, containing a logical
\code{spe$exclude_overlapping} column specifying which spots to display in
plots}

\item{point_size}{A \code{numeric(1)} specifying the size of the points. Defaults
to \code{1.25}. Some colors look better if you use \code{2} for instance.}

\item{image_id}{A \code{character(1)} with the name of the image ID you want to
use in the background.}
}
\value{
A list with names \code{spe} and \code{point_size} containing a
filtered, ready-to-plot \code{SpatialExperiment} and an appropriate spot size
(passed to \code{vis_gene()} or \code{vis_clus()}), respectively
}
\description{
Given a \code{SpatialExperiment} built with \code{visiumStitched::build_spe()}
\url{http://research.libd.org/visiumStitched/reference/build_spe.html}, drop
excluded spots (specified by \code{spe$exclude_overlapping}) and compute an
appropriate spot size for plotting with \code{vis_gene()} or
\code{vis_clus()}, assuming the plot will be written to a PDF of default
dimensions (i.e. \code{width = 7} and \code{height = 7}).
}
\author{
Nicholas J. Eagles
}
\keyword{internal}
