% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_export.R
\name{cluster_export}
\alias{cluster_export}
\title{Export a column with cluster results}
\usage{
cluster_export(
  spe,
  cluster_var,
  cluster_dir = file.path(tempdir(), "exported_clusters"),
  overwrite = TRUE
)
}
\arguments{
\item{spe}{A
\link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class}
object. See \code{\link[=fetch_data]{fetch_data()}} for how to download some example objects or
\code{\link[=read10xVisiumWrapper]{read10xVisiumWrapper()}} to read in \code{spaceranger --count} output files and
build your own \code{spe} object.}

\item{cluster_var}{A \code{character(1)} with the name of the variable you wish to
export.}

\item{cluster_dir}{A \code{character(1)} specifying the output directory, similar
to the \code{outs/analysis/clustering} produced by SpaceRanger.}

\item{overwrite}{A \code{logical(1)} indicating whether to overwrite the \code{spe$key}.}
}
\value{
The path to the exported \code{clusters.csv} file.
}
\description{
This function creates a \code{clusters.csv} file similar to the ones created by
SpaceRanger at \code{outs/analysis/clustering} but with the \code{key} column that
combines the \code{barcode} and the \code{sample_id}, which is needed when the \code{spe}
object contains data from multiple samples given that the barcodes are
duplicated.
}
\examples{
if (enough_ram()) {
    ## Obtain the necessary data
    if (!exists("spe")) spe <- fetch_data("spe")

    ## Export two cluster variables
    cluster_export(spe, "spatialLIBD")
    cluster_export(spe, "GraphBased")
}
}
\seealso{
Other cluster export/import utility functions: 
\code{\link{cluster_import}()}
}
\concept{cluster export/import utility functions}
