% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_spe.R
\name{check_spe}
\alias{check_spe}
\title{Check input spe}
\usage{
check_spe(
  spe,
  variables = c("sum_umi", "sum_gene", "expr_chrM", "expr_chrM_ratio")
)
}
\arguments{
\item{spe}{A
\link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class}
object. See \code{\link[=fetch_data]{fetch_data()}} for how to download some example objects or
\code{\link[=read10xVisiumWrapper]{read10xVisiumWrapper()}} to read in \code{spaceranger --count} output files and
build your own \code{spe} object.}

\item{variables}{A \code{character()} vector of variable names expected to
be present in \code{colData(spe)}.}
}
\value{
The input object if all checks are passed.
}
\description{
This function checks that the \code{spe} object has the appropriate structure.
For more details please check the vignette documentation.
}
\examples{

if (enough_ram()) {
    ## Obtain the necessary data
    if (!exists("spe")) spe <- fetch_data("spe")

    ## Check the object
    check_spe(spe)
}
}
\seealso{
Other Check input functions: 
\code{\link{check_modeling_results}()},
\code{\link{check_sce}()},
\code{\link{check_sce_layer}()}
}
\author{
Brenda Pardo, Leonardo Collado-Torres
}
\concept{Check input functions}
