% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add10xVisiumAnalysis.R
\name{add10xVisiumAnalysis}
\alias{add10xVisiumAnalysis}
\title{Add analysis data from a 10x Genomics Visium experiment to a SPE object}
\usage{
add10xVisiumAnalysis(spe, visium_analysis)
}
\arguments{
\item{spe}{A
\link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class} object.}

\item{visium_analysis}{The output from \code{read10xVisiumAnalysis()}.}
}
\value{
A
\link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class} object
with the clustering results from SpaceRanger added to \code{colData(spe)} and
the dimension reduction results added to \code{reducedDims(spe)}. Added data
starts with the \verb{10x_} prefix to make them easy to differentiate.
}
\description{
This function adds to a SPE
(\link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class})
object the output from \code{read10xVisiumAnalysis()}.
}
\details{
You might want to use \code{read10xVisiumWrapper()} instead of using this
function directly.
}
\examples{
## See 'Using spatialLIBD with 10x Genomics public datasets' for
## a full example using this function.
if (interactive()) {
    browseVignettes(package = "spatialLIBD")
}

## Note that ?SpatialExperiment::read10xVisium doesn't include all the files
## we need to illustrate read10xVisiumWrapper().
}
\seealso{
Other Utility functions for reading data from SpaceRanger output by 10x
Genomics: 
\code{\link{read10xVisiumAnalysis}()},
\code{\link{read10xVisiumWrapper}()}
}
\concept{Utility functions for reading data from SpaceRanger output by 10x
Genomics}
