library("here")
library("sessioninfo")


outdir <- "spatialLIBD_files"
pkgname <- "spatialLIBD"


meta <- data.frame(
    Title = c(
        "Visium_SPG_AD_Visium_wholegenome_spe",
        "Visium_SPG_AD_Visium_targeted_spe",
        "Visium_SPG_AD_Visium_wholegenome_pseudobulk_spe",
        "Visium_SPG_AD_Visium_wholegenome_modeling_results"
    ),
    Description = c(
        "SpatialExperiment object at the spot-level for the Visium_SPG_AD human brain (inferior temporal cortex ITC) Alzheimer's Disease (AD) spatial transcriptomics data (n = 10) from the Visium Spatial Proteogenomics (Visium-SPG) platform from 10x Genomics (at the whole genome level) generated by the Lieber Institute for Brain Development (LIBD) and available through the spatialLIBD Bioconductor package.",
        "SpatialExperiment object at the spot-level for the Visium_SPG_AD human brain (inferior temporal cortex ITC) Alzheimer's Disease (AD) spatial transcriptomics data (n = 10) from the Visium Spatial Proteogenomics (Visium-SPG) platform from 10x Genomics (with a targeted sequencing panel) generated by the Lieber Institute for Brain Development (LIBD) and available through the spatialLIBD Bioconductor package.",
        "Pseudo-bulked SingleCellExperiment object (SpatialExperiment object without spatial data) for the seven Alzheimer's Disease (AD) pathology levels from the Visium_SPG_AD human brain (inferior temporal cortex ITC) Alzheimer's Disease (AD) spatial transcriptomics data (n = 10) from the Visium Spatial Proteogenomics (Visium-SPG) platform from 10x Genomics (at the whole genome level) generated by the Lieber Institute for Brain Development (LIBD) and available through the spatialLIBD Bioconductor package.",
        "List of modeling results for the seven Alzheimer's Disease (AD) pathology levels from the Visium_SPG_AD human brain (inferior temporal cortex ITC) Alzheimer's Disease (AD) spatial transcriptomics data (n = 10) from the Visium Spatial Proteogenomics (Visium-SPG) platform from 10x Genomics (at the whole genome level) generated by the Lieber Institute for Brain Development (LIBD) and available through the spatialLIBD Bioconductor package."
    ),
    BiocVersion = "3.17",
    Genome = "GRCh38",
    SourceType = "GTF",
    SourceUrl = "https://bioconductor.org/packages/spatialLIBD",
    SourceVersion = "Mar 17 2023",
    Species = "Homo sapiens",
    TaxonomyId = 9606,
    Coordinate_1_based = TRUE,
    DataProvider = "LIBD",
    Maintainer = "Leonardo Collado-Torres <lcolladotor@gmail.com>",
    RDataClass = c(
        "SpatialExperiment",
        "SpatialExperiment",
        "SpatialExperiment",
        "list"
    ),
    DispatchClass = c("Rda", "Rda", "Rds", "Rds"),
    RDataPath = file.path(
        pkgname,
        outdir,
        c(
            "Visium_SPG_AD_spe_wholegenome.Rdata",
            "Visium_SPG_AD_spe_targeted.Rdata",
            "sce_pseudo_pathology_wholegenome.rds",
            "Visium_IF_AD_modeling_results.Rdata"
        )
    ),
    Tags = "Visium_SPG_AD_Alzheimer_Disease_ITC_spatialLIBD",
    row.names = NULL,
    stringsAsFactors = FALSE
)

write.csv(
    meta,
    file = here::here("inst", "extdata", "metadata_Visium_SPG_AD.csv"),
    row.names = FALSE
)

## Check
if (FALSE) {
    AnnotationHubData::makeAnnotationHubMetadata(here::here(), fileName = "metadata_Visium_SPG_AD.csv")
}

## Reproducibility information
print("Reproducibility information:")
Sys.time()
proc.time()
options(width = 120)
session_info()
