% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCmapCEL.R
\name{getCmapCEL}
\alias{getCmapCEL}
\title{Download CMap2 CEL Files}
\usage{
getCmapCEL(rerun = TRUE, dest_dir = tempdir())
}
\arguments{
\item{rerun}{TRUE or FALSE, whether to download the data}

\item{dest_dir}{character(1), path to the destination directory}
}
\value{
download files
}
\description{
This function will download the 7,056 CEL files from the CMap2 project 
site (http://www.broadinstitute.org/cmap), and save each of them to a
subdirectory named CEL under data. Since this download step will take 
a long time, the \code{rerun} argument has been assigned \code{FALSE} in
the example code below to avoid running it accidentally. If the raw data are not
needed, users can skip this time consuming step and work with the preprocessed
\code{\link{cmap}} or \code{\link{cmap_expr}} database downloaded from the 
ExperimentHub instead.
}
\examples{
getCmapCEL(rerun=FALSE) # set 'rerun' to TRUE if download
}
