% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surveyDatasets.R
\name{surveyDatasets}
\alias{surveyDatasets}
\title{Survey of dataset metadata}
\usage{
surveyDatasets(cache = cacheDirectory(), overwrite = FALSE, latest = TRUE)
}
\arguments{
\item{cache, overwrite}{Arguments to pass to \code{\link[gypsum]{fetchMetadataDatabase}}.}

\item{latest}{Whether to only consider the latest version of each dataset.}
}
\value{
A \link[S4Vectors]{DataFrame} where each row corresponds to a (sub)dataset, containing various columns of metadata.
Some columns may be lists to capture 1:many mappings.
}
\description{
Metadata survey for all available datasets in the \pkg{scRNAseq} package.
}
\details{
The returned DataFrame contains the usual suspects like the title and description for each dataset,
the number of rows and columns, the organisms and genome builds involved,
whether the dataset has any pre-computed reduced dimensions, and so on.
More details can be found in the Bioconductor metadata schema at \url{https://github.com/ArtifactDB/bioconductor-metadata-index}. 

If a dataset contains multiple subdatasets, each subdataset is reported as a separate row in the DataFrame.
The location of subdataset is provided in the \code{path} column.
If a dataset does not contain any subdatasets, the \code{path} entry will be set to \code{NA}.
}
\examples{
surveyDatasets()

}
\seealso{
\code{\link{searchDatasets}}, to search on the metadata for specific datasets.
}
\author{
Aaron Lun
}
